/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.NoLoadScriptSecurity;
import org.apache.batik.bridge.RelaxedScriptSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.LengthKey;
import org.apache.batik.transcoder.keys.Rectangle2DKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGAbstractTranscoder
extends XMLAbstractTranscoder {
    protected Rectangle2D curAOI;
    protected AffineTransform curTxf;
    protected GraphicsNode root;
    protected float width;
    protected float height;
    protected UserAgent userAgent = this.createUserAgent();
    public static final TranscodingHints.Key KEY_WIDTH = new LengthKey();
    public static final TranscodingHints.Key KEY_HEIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_AOI = new Rectangle2DKey();
    public static final TranscodingHints.Key KEY_LANGUAGE = new StringKey();
    public static final TranscodingHints.Key KEY_MEDIA = new StringKey();
    public static final TranscodingHints.Key KEY_ALTERNATE_STYLESHEET = new StringKey();
    public static final TranscodingHints.Key KEY_USER_STYLESHEET_URI = new StringKey();
    public static final TranscodingHints.Key KEY_PIXEL_UNIT_TO_MILLIMETER;
    public static final TranscodingHints.Key KEY_PIXEL_TO_MM;
    public static final TranscodingHints.Key KEY_EXECUTE_ONLOAD;
    public static final TranscodingHints.Key KEY_ALLOWED_SCRIPT_TYPES;
    public static final String DEFAULT_ALLOWED_SCRIPT_TYPES = "text/ecmascript, application/java-archive";
    public static final TranscodingHints.Key KEY_CONSTRAIN_SCRIPT_ORIGIN;

    protected SVGAbstractTranscoder() {
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, "http://www.w3.org/2000/svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT, "svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION, ExtensibleSVGDOMImplementation.getDOMImplementation());
        this.hints.put(KEY_MEDIA, "screen");
        this.hints.put(KEY_EXECUTE_ONLOAD, Boolean.FALSE);
        this.hints.put(KEY_ALLOWED_SCRIPT_TYPES, DEFAULT_ALLOWED_SCRIPT_TYPES);
    }

    protected UserAgent createUserAgent() {
        return new SVGAbstractTranscoderUserAgent();
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation domImpl, String parserClassname) {
        return new SAXSVGDocumentFactory(parserClassname);
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        AffineTransform Px;
        GraphicsNode gvtRoot;
        if (!(document instanceof SVGOMDocument)) {
            throw new TranscoderException(Messages.formatMessage("notsvg", null));
        }
        BridgeContext ctx = new BridgeContext(this.userAgent);
        SVGOMDocument svgDoc = (SVGOMDocument)document;
        SVGSVGElement root = svgDoc.getRootElement();
        GVTBuilder builder = new GVTBuilder();
        boolean isDynamic = this.hints.containsKey(KEY_EXECUTE_ONLOAD) && (Boolean)this.hints.get(KEY_EXECUTE_ONLOAD) != false && BaseScriptingEnvironment.isDynamicDocument(svgDoc);
        ctx.setDynamic(isDynamic);
        try {
            gvtRoot = builder.build(ctx, svgDoc);
            if (ctx.isDynamic()) {
                BaseScriptingEnvironment se = new BaseScriptingEnvironment(ctx);
                se.loadScripts();
                se.dispatchSVGLoadEvent();
            }
        }
        catch (BridgeException ex) {
            throw new TranscoderException(ex);
        }
        float docWidth = (float)ctx.getDocumentSize().getWidth();
        float docHeight = (float)ctx.getDocumentSize().getHeight();
        ctx = null;
        builder = null;
        float imgWidth = -1.0f;
        if (this.hints.containsKey(KEY_WIDTH)) {
            imgWidth = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
        }
        float imgHeight = -1.0f;
        if (this.hints.containsKey(KEY_HEIGHT)) {
            imgHeight = ((Float)this.hints.get(KEY_HEIGHT)).floatValue();
        }
        if (imgWidth > 0.0f && imgHeight > 0.0f) {
            this.width = imgWidth;
            this.height = imgHeight;
        } else if (imgHeight > 0.0f) {
            this.width = docWidth * imgHeight / docHeight;
            this.height = imgHeight;
        } else if (imgWidth > 0.0f) {
            this.width = imgWidth;
            this.height = docHeight * imgWidth / docWidth;
        } else {
            this.width = docWidth;
            this.height = docHeight;
        }
        String ref = new ParsedURL(uri).getRef();
        try {
            Px = ViewBox.getViewTransform(ref, root, this.width, this.height);
        }
        catch (BridgeException ex) {
            throw new TranscoderException(ex);
        }
        if (Px.isIdentity() && (this.width != docWidth || this.height != docHeight)) {
            float d = Math.max(docWidth, docHeight);
            float dd = Math.max(this.width, this.height);
            float scale = dd / d;
            Px = AffineTransform.getScaleInstance(scale, scale);
        }
        if (this.hints.containsKey(KEY_AOI)) {
            Rectangle2D aoi = (Rectangle2D)this.hints.get(KEY_AOI);
            aoi = Px.createTransformedShape(aoi).getBounds2D();
            AffineTransform Mx = new AffineTransform();
            double sx = (double)this.width / aoi.getWidth();
            double sy = (double)this.height / aoi.getHeight();
            Mx.scale(sx, sy);
            double tx = -aoi.getX();
            double ty = -aoi.getY();
            Mx.translate(tx, ty);
            Px.preConcatenate(Mx);
            this.curAOI = aoi;
        } else {
            this.curAOI = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
        }
        this.curTxf = Px;
        this.root = gvtRoot;
    }

    static {
        KEY_PIXEL_TO_MM = KEY_PIXEL_UNIT_TO_MILLIMETER = new FloatKey();
        KEY_EXECUTE_ONLOAD = new BooleanKey();
        KEY_ALLOWED_SCRIPT_TYPES = new StringKey();
        DEFAULT_ALLOWED_SCRIPT_TYPES = DEFAULT_ALLOWED_SCRIPT_TYPES;
        KEY_CONSTRAIN_SCRIPT_ORIGIN = new BooleanKey();
    }

    protected class SVGAbstractTranscoderUserAgent
    extends UserAgentAdapter {
        protected Vector scripts;

        public SVGAbstractTranscoderUserAgent() {
            this.addStdFeatures();
        }

        public Dimension2D getViewportSize() {
            return new Dimension(400, 400);
        }

        public void displayError(String message) {
            try {
                SVGAbstractTranscoder.this.handler.error(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception e) {
            try {
                SVGAbstractTranscoder.this.handler.error(new TranscoderException(e));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String message) {
            try {
                SVGAbstractTranscoder.this.handler.warning(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public float getPixelUnitToMillimeter() {
            Object obj = SVGAbstractTranscoder.this.hints.get(KEY_PIXEL_UNIT_TO_MILLIMETER);
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            return super.getPixelUnitToMillimeter();
        }

        public String getLanguages() {
            if (SVGAbstractTranscoder.this.hints.containsKey(KEY_LANGUAGE)) {
                return (String)SVGAbstractTranscoder.this.hints.get(KEY_LANGUAGE);
            }
            return super.getLanguages();
        }

        public String getMedia() {
            String s = (String)SVGAbstractTranscoder.this.hints.get(KEY_MEDIA);
            if (s != null) {
                return s;
            }
            return super.getMedia();
        }

        public String getAlternateStyleSheet() {
            String s = (String)SVGAbstractTranscoder.this.hints.get(KEY_ALTERNATE_STYLESHEET);
            if (s != null) {
                return s;
            }
            return super.getAlternateStyleSheet();
        }

        public String getUserStyleSheetURI() {
            String s = (String)SVGAbstractTranscoder.this.hints.get(KEY_USER_STYLESHEET_URI);
            if (s != null) {
                return s;
            }
            return super.getUserStyleSheetURI();
        }

        public String getXMLParserClassName() {
            String s = (String)SVGAbstractTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
            if (s != null) {
                return s;
            }
            return super.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            Boolean b = (Boolean)SVGAbstractTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING);
            if (b != null) {
                return b;
            }
            return super.isXMLParserValidating();
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptPURL, ParsedURL docPURL) {
            if (this.scripts == null) {
                this.computeAllowedScripts();
            }
            if (!this.scripts.contains(scriptType)) {
                return new NoLoadScriptSecurity(scriptType);
            }
            boolean constrainOrigin = true;
            if (SVGAbstractTranscoder.this.hints.containsKey(KEY_CONSTRAIN_SCRIPT_ORIGIN)) {
                constrainOrigin = (Boolean)SVGAbstractTranscoder.this.hints.get(KEY_CONSTRAIN_SCRIPT_ORIGIN);
            }
            if (constrainOrigin) {
                return new DefaultScriptSecurity(scriptType, scriptPURL, docPURL);
            }
            return new RelaxedScriptSecurity(scriptType, scriptPURL, docPURL);
        }

        protected void computeAllowedScripts() {
            this.scripts = new Vector();
            if (!SVGAbstractTranscoder.this.hints.containsKey(KEY_ALLOWED_SCRIPT_TYPES)) {
                return;
            }
            String allowedScripts = (String)SVGAbstractTranscoder.this.hints.get(KEY_ALLOWED_SCRIPT_TYPES);
            StringTokenizer st = new StringTokenizer(allowedScripts, ",");
            while (st.hasMoreTokens()) {
                this.scripts.addElement(st.nextToken());
            }
        }
    }
}

