/*

 AbstractSubModulePanel.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/15

 */
package net.sf.sqs_xml.editor.base.modules.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.util.DOMUtil;

import org.w3c.dom.Node;

/**
 * @author hiroya
 *
 */
public abstract class AbstractSingleNodeEditorPanel extends AbstractNodeEditorPanel{
    JTextArea nodeValueTextArea;
    JComponent nodeValueEditor;
    String previousValue = null;
    JPopupMenu popup;
    
    
    void showPopup(int x, int y){
        popup.show(this.nodeValueTextArea, x, y);
    }

    public AbstractSingleNodeEditorPanel(AbstractNodeEditor editor){
        super(editor);
        createPopupMenu();
        
        this.nodeValueTextArea = new JTextArea(3, 30);
        this.nodeValueTextArea.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                /*
                JComponent c = (JComponent)e.getSource();
                TransferHandler th = c.getTransferHandler();
                th.exportAsDrag(c, e, TransferHandler.COPY);
                System.err.println(e.getButton());
                */
                if(e.getButton() == MouseEvent.BUTTON3 && ! popup.isVisible()){
                    showPopup(e.getX(), e.getY());
                }
            }
            public void mouseReleased(MouseEvent e) {
                if(e.getButton() == MouseEvent.BUTTON3 && ! popup.isVisible()){
                    showPopup(e.getX(), e.getY());
                }
            }
        });

        this.nodeValueEditor = createNodeValueEditor(nodeValueTextArea);
        initNodeValueEditor(editor);
        this.add(nodeValueEditor);
        if(editor.getSource().isReadOnly()){
            nodeValueTextArea.setEnabled(false);
        }
        initSize();
    }
    
    private void createPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem cutMenu = new JMenuItem("カット    Ctrl-X");
        JMenuItem copyMenu = new JMenuItem("コピー    Ctrl-C");
        JMenuItem pasteMenu = new JMenuItem("貼り付け  Ctrl-V");
        JMenuItem selectAllMenu = new JMenuItem("全て選択  Ctrl-A");
        cutMenu.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ev){
                nodeValueTextArea.cut();
            }
        });
        copyMenu.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ev){
                nodeValueTextArea.copy();
            }
        });
        pasteMenu.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ev){
                nodeValueTextArea.paste();
            }
        });
        selectAllMenu.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ev){
                nodeValueTextArea.selectAll();
            }
        });
        popup.add(cutMenu);
        popup.add(copyMenu);
        popup.add(pasteMenu);
        popup.addSeparator();
        popup.add(selectAllMenu);
    }

    private void initNodeValueEditor(AbstractNodeEditor editor) {
        if(editor.getNode() != null){
            try{
                Node node = (Node)editor.getNode();
                this.previousValue = DOMUtil.stringValueOf(editor.getSource().getDocument(), node, getDescriptionXPath());
                nodeValueTextArea.setText(previousValue);
            }catch(ClassCastException ignore){
                ignore.printStackTrace();
            }
        }
    }

    public JComponent createNodeValueEditor(JTextArea nodeValueTextArea){
        JComponent nodeValueEditor = Box.createHorizontalBox();
        nodeValueEditor.add(new JScrollPane(nodeValueTextArea));
        nodeValueTextArea.addFocusListener(editor.getUpdateListener());
        return nodeValueEditor;
    }
    
    public abstract String getDescriptionXPath();
    
    public String getDescriptionLabel(){
        return "";
    }
    
    public boolean updateNodeValue(){
        if(previousValue == null || ! previousValue.equals(nodeValueTextArea.getText())){
            editor.updateNodeValue(getDescriptionXPath(), nodeValueTextArea.getText());
            return true;
        }
        return false;
    }

}
