/*

 FileContentServlet.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/10/18

 */
package net.sf.sqs_xml.httpd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.sqs_xml.util.FileUtil;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 * @author hiroya
 *
 */
public class FileContentServlet extends HttpServlet {

    public FileContentServlet()throws ServletException{
        super();
    }

    static Map altPathMap = new HashMap();
    static Map altPathMapRev = new HashMap();

    public void service(HttpServletRequest request, HttpServletResponse response)throws ServletException, IOException{
        String pathInfo = request.getPathInfo();
        String suffix = FileUtil.getSuffix(pathInfo);
        String encoding = null;
        
        if("txt".equals(suffix)){
            encoding = "MS932"; 
            response.setContentType("text/plain; charset="+encoding);
            response.setCharacterEncoding(encoding);
        }else if("html".equals(suffix)){
            encoding = "UTF-8";
            response.setCharacterEncoding("text/html; charset="+encoding);
        }else{
            String mime = (String)MicroHttpd.mimeMap.get(suffix);
            response.setContentType(mime);
        }
        
        File target = getFile(pathInfo);
        
        int length;
        if("html".equals(suffix)){
            try {
                PrintWriter writer = FileUtil.createPrintWriter(response.getOutputStream(), encoding);
                String parserClass = "org.apache.crimson.parser.XMLReaderImpl";
                XMLReader reader = XMLReaderFactory.createXMLReader(parserClass);
                //reader.setFeature("http://xml.org/sax/features/namespaces",true);
                MicroHttpd httpd = SQSHttpdFactory.getInitialHttpd();
                URLFilter filter = new URLFilter(httpd, target.getParent());
                filter.setParent(reader);
                DataHandler handler = new DataHandler(writer);
                filter.setContentHandler(handler);
                reader.setErrorHandler(handler);
                InputSource file = new InputSource(new FileInputStream(target));
                filter.parse(file);
                writer.close();
            } catch (IOException ioe) {
                System.out.println("IO Exception: "+ioe.getLocalizedMessage());
            } catch(SAXException ex) {
                System.out.println("SAX Exception: "+ex.getLocalizedMessage());
            } 
        }else if("txt".equals(suffix)){
            Writer writer = new BufferedWriter(response.getWriter());
            char[] buf = new char[4096];
            Reader reader = FileUtil.createReader(new FileInputStream(target), encoding);
            while(0 < (length = reader.read(buf, 0, 4096))){
                writer.write(buf, 0, length);
            }
            reader.close();
            writer.close();
        }else{
            OutputStream writer = new BufferedOutputStream(response.getOutputStream());        
            byte[] buf = new byte[4096];
            InputStream stream = new BufferedInputStream(new FileInputStream(getFile(pathInfo)));
            while(0 < (length = stream.read(buf, 0, 4096))){
                writer.write(buf, 0, length);
            }
            stream.close();
            writer.close();
        }
    }
    
    public static File getFile(String pathInContext) {
        if (pathInContext == null || pathInContext.length() == 0) {
            return null;
        }
        try {
            int separatorPosition = pathInContext.indexOf(".", 1);
            Integer altPathID = null;
            if(0 < separatorPosition){
                altPathID = new Integer(Integer.parseInt(pathInContext.substring(1, separatorPosition)));
            }else{
                altPathID = new Integer(Integer.parseInt(pathInContext.substring(1)));
            }
            String fileName = pathInContext.substring(separatorPosition + 1);
            return (File)altPathMapRev.get(altPathID);

        } catch (Exception ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    static synchronized URL getAltURL(String base, File file) {
        Integer altPathID;
        if (altPathMap.containsKey(file)) {
            altPathID = (Integer) altPathMap.get(file);
        } else {
            altPathID = new Integer(altPathMap.size());
            altPathMap.put(file, altPathID);
            altPathMapRev.put(altPathID, file);
        }
        try {
            String name = file.getName();
            if (file.isDirectory()) {
                return new URL(base + "File/" + altPathID.toString());
            } else {
                return new URL(base + "File/" + altPathID.toString() + name.substring(name.indexOf(".")));
            }
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

class DataHandler extends DefaultHandler{
    PrintWriter writer;
    DataHandler(PrintWriter writer){
        this.writer = writer;
    }
    
    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String namespaceURI,
            String localName,
            String qName,
            Attributes atts) {
        StringBuffer attstr = new StringBuffer();
        for(int i = 0; i < atts.getLength(); i++){
            String aQName = atts.getQName(i);
            String aValue = atts.getValue(i);
            attstr.append(" ").append(aQName).append("=\"").append(aValue).append("\"");
        }
        writer.print("<"+qName+attstr+">");
    }

    public void endElement(String namespaceURI,
            String localName,
            String qName) {
        writer.print("</"+qName+">");
    }

    public void characters(char[] ch, int start, int length) {
        for (int i = 0; i < length; i++) {
          writer.print(ch[start + i]);
        }
    }
    
    public void error(SAXParseException ex){
        //System.err.println(ex.getPublicId()+":"+ex.getSystemId()+":"+ex.getLocalizedMessage());
        ex.printStackTrace();
    }
    
    public void fatalError(SAXParseException ex){
        System.err.println(ex.getPublicId()+":"+ex.getSystemId()+":"+ex.getLocalizedMessage());
        ex.printStackTrace();
    }

    public void warning(SAXParseException ex){
        ex.printStackTrace();
    } 
}

