/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package net.sf.sqs_xml.reader.model;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>ImageFiles</b> is generated from reader.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="imagefiles" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader">
 *       <zeroOrMore>
 *           <element name="imagefile" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader">
 *             <attribute name="filename" java:mapKey="true">
 *               <text/>
 *             </attribute>
 *             <attribute name="mtime">
 *                           <data type="dateTime"/>
 *             </attribute>            
 *             <optional>
 *               <ref name="ScanFrame"/>
 *             </optional>
 *             
 *           </element>
 *       </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="imagefiles" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader"&gt;
 *       &lt;zeroOrMore&gt;
 *           &lt;element name="imagefile" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader"&gt;
 *             &lt;attribute name="filename" java:mapKey="true"&gt;
 *               &lt;text/&gt;
 *             &lt;/attribute&gt;
 *             &lt;attribute name="mtime"&gt;
 *                           &lt;data type="dateTime"/&gt;
 *             &lt;/attribute&gt;            
 *             &lt;optional&gt;
 *               &lt;ref name="ScanFrame"/&gt;
 *             &lt;/optional&gt;
 *             
 *           &lt;/element&gt;
 *       &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version reader.rng (Fri Aug 06 03:48:33 GMT+09:00 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class ImageFiles implements java.io.Serializable, Cloneable, IRNSContainer, IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
    // List<ImageFilesImagefile>
    private java.util.List imageFilesImagefile_ = new java.util.ArrayList();
    private java.util.Map imageFilesImagefile_$map = new java.util.HashMap();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>ImageFiles</code>.
     *
     */
    public ImageFiles() {
    }

    /**
     * Creates a <code>ImageFiles</code>.
     *
     * @param source
     */
    public ImageFiles(ImageFiles source) {
        setup(source);
    }

    /**
     * Creates a <code>ImageFiles</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public ImageFiles(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>ImageFiles</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public ImageFiles(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>ImageFiles</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public ImageFiles(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>ImageFiles</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ImageFiles(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>ImageFiles</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ImageFiles(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>ImageFiles</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ImageFiles(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>ImageFiles</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ImageFiles(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>ImageFiles</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ImageFiles(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>ImageFiles</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ImageFiles(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>ImageFiles</code> by the ImageFiles <code>source</code>.
     *
     * @param source
     */
    public void setup(ImageFiles source) {
        int size;
        this.imageFilesImagefile_.clear();
        size = source.imageFilesImagefile_.size();
        for (int i = 0;i < size;i++) {
            addImageFilesImagefile((ImageFilesImagefile)source.getImageFilesImagefile(i).clone());
        }
    }

    /**
     * Initializes the <code>ImageFiles</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>ImageFiles</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>ImageFiles</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        imageFilesImagefile_.clear();
        while (true) {
            if (ImageFilesImagefile.isMatch(stack)) {
                addImageFilesImagefile(new ImageFilesImagefile(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new ImageFiles((ImageFiles)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "imagefiles");
        rNSContext_.setupNamespace(element);
        int size;
        size = this.imageFilesImagefile_.size();
        for (int i = 0;i < size;i++) {
            ImageFilesImagefile value = (ImageFilesImagefile)this.imageFilesImagefile_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>ImageFiles</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>ImageFiles</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>ImageFiles</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>ImageFiles</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>ImageFiles</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>ImageFiles</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the ImageFilesImagefile property <b>ImageFilesImagefile</b>.
     *
     * @return ImageFilesImagefile[]
     */
    public ImageFilesImagefile[] getImageFilesImagefile() {
        ImageFilesImagefile[] array = new ImageFilesImagefile[imageFilesImagefile_.size()];
        return ((ImageFilesImagefile[])imageFilesImagefile_.toArray(array));
    }

    /**
     * Sets the ImageFilesImagefile property <b>ImageFilesImagefile</b>.
     *
     * @param imageFilesImagefile
     */
    public void setImageFilesImagefile(ImageFilesImagefile[] imageFilesImagefile) {
        this.imageFilesImagefile_.clear();
        for (int i = 0;i < imageFilesImagefile.length;i++) {
            addImageFilesImagefile(imageFilesImagefile[i]);
        }
        for (int i = 0;i < imageFilesImagefile.length;i++) {
            imageFilesImagefile[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the ImageFilesImagefile property <b>ImageFilesImagefile</b>.
     *
     * @param imageFilesImagefile
     */
    public void setImageFilesImagefile(ImageFilesImagefile imageFilesImagefile) {
        this.imageFilesImagefile_.clear();
        addImageFilesImagefile(imageFilesImagefile);
        if (imageFilesImagefile != null) {
            imageFilesImagefile.rSetParentRNode(this);
        }
    }

    /**
     * Adds the ImageFilesImagefile property <b>ImageFilesImagefile</b>.
     *
     * @param imageFilesImagefile
     */
    public void addImageFilesImagefile(ImageFilesImagefile imageFilesImagefile) {
        Object $key$ = imageFilesImagefile.getFilename();
        if ($key$ != null) {
            Object $value$ = this.imageFilesImagefile_$map.get($key$);
            if ($value$ != null) {
                this.imageFilesImagefile_.remove($value$);
        }
            this.imageFilesImagefile_$map.put($key$, imageFilesImagefile);
        }
        this.imageFilesImagefile_.add(imageFilesImagefile);
        if (imageFilesImagefile != null) {
            imageFilesImagefile.rSetParentRNode(this);
        }
    }

    /**
     * Adds the ImageFilesImagefile property <b>ImageFilesImagefile</b>.
     *
     * @param imageFilesImagefile
     */
    public void addImageFilesImagefile(ImageFilesImagefile[] imageFilesImagefile) {
        for (int i = 0;i < imageFilesImagefile.length;i++) {
            addImageFilesImagefile(imageFilesImagefile[i]);
        }
        for (int i = 0;i < imageFilesImagefile.length;i++) {
            imageFilesImagefile[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the ImageFilesImagefile property <b>ImageFilesImagefile</b>.
     *
     * @return int
     */
    public int sizeImageFilesImagefile() {
        return (imageFilesImagefile_.size());
    }

    /**
     * Gets the ImageFilesImagefile property <b>ImageFilesImagefile</b> by index.
     *
     * @param index
     * @return ImageFilesImagefile
     */
    public ImageFilesImagefile getImageFilesImagefile(int index) {
        return ((ImageFilesImagefile)imageFilesImagefile_.get(index));
    }

    /**
     * Sets the ImageFilesImagefile property <b>ImageFilesImagefile</b> by index.
     *
     * @param index
     * @param imageFilesImagefile
     */
    public void setImageFilesImagefile(int index, ImageFilesImagefile imageFilesImagefile) {
        Object $key$ = imageFilesImagefile.getFilename();
        if ($key$ != null) {
            Object $value$ = this.imageFilesImagefile_$map.get($key$);
            if ($value$ != null) {
                this.imageFilesImagefile_.remove($value$);
        }
            this.imageFilesImagefile_$map.put($key$, imageFilesImagefile);
        }
        this.imageFilesImagefile_.set(index, imageFilesImagefile);
        if (imageFilesImagefile != null) {
            imageFilesImagefile.rSetParentRNode(this);
        }
    }

    /**
     * Adds the ImageFilesImagefile property <b>ImageFilesImagefile</b> by index.
     *
     * @param index
     * @param imageFilesImagefile
     */
    public void addImageFilesImagefile(int index, ImageFilesImagefile imageFilesImagefile) {
        Object $key$ = imageFilesImagefile.getFilename();
        if ($key$ != null) {
            Object $value$ = this.imageFilesImagefile_$map.get($key$);
            if ($value$ != null) {
                this.imageFilesImagefile_.remove($value$);
        }
            this.imageFilesImagefile_$map.put($key$, imageFilesImagefile);
        }
        this.imageFilesImagefile_.add(index, imageFilesImagefile);
        if (imageFilesImagefile != null) {
            imageFilesImagefile.rSetParentRNode(this);
        }
    }

    /**
     * Remove the ImageFilesImagefile property <b>ImageFilesImagefile</b> by index.
     *
     * @param index
     */
    public void removeImageFilesImagefile(int index) {
        ImageFilesImagefile $value$ = (ImageFilesImagefile)imageFilesImagefile_.get(index);
        if ($value$ != null) {
            removeImageFilesImagefile($value$);
        }
        this.imageFilesImagefile_.remove(index);
    }

    /**
     * Remove the ImageFilesImagefile property <b>ImageFilesImagefile</b> by object.
     *
     * @param imageFilesImagefile
     */
    public void removeImageFilesImagefile(ImageFilesImagefile imageFilesImagefile) {
        Object $key$ = imageFilesImagefile.getFilename();
        this.imageFilesImagefile_$map.remove($key$);
        this.imageFilesImagefile_.remove(imageFilesImagefile);
    }

    /**
     * Clear the ImageFilesImagefile property <b>ImageFilesImagefile</b>.
     *
     */
    public void clearImageFilesImagefile() {
        this.imageFilesImagefile_$map.clear();
        this.imageFilesImagefile_.clear();
    }

    /**
     * Gets the ImageFilesImagefile property <b>ImageFilesImagefile</b> by key.
     *
     * @param key
     * @return ImageFilesImagefile
     */
    public ImageFilesImagefile getImageFilesImagefileByFilename(String key) {
        return ((ImageFilesImagefile)imageFilesImagefile_$map.get(key));
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.append("<");
        URelaxer.makeQName(prefix, "imagefiles", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.append(">");
        size = this.imageFilesImagefile_.size();
        for (int i = 0;i < size;i++) {
            ImageFilesImagefile value = (ImageFilesImagefile)this.imageFilesImagefile_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "imagefiles", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.write("<");
        URelaxer.makeQName(prefix, "imagefiles", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.write(">");
        size = this.imageFilesImagefile_.size();
        for (int i = 0;i < size;i++) {
            ImageFilesImagefile value = (ImageFilesImagefile)this.imageFilesImagefile_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "imagefiles", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.print("<");
        URelaxer.makeQName(prefix, "imagefiles", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.print(">");
        size = this.imageFilesImagefile_.size();
        for (int i = 0;i < size;i++) {
            ImageFilesImagefile value = (ImageFilesImagefile)this.imageFilesImagefile_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "imagefiles", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(imageFilesImagefile_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>ImageFiles</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "imagefiles")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (!ImageFilesImagefile.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ImageFiles</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ImageFiles</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
