/*

 ImagePanel.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on Jul 23, 2004

 */
package net.sf.sqs_xml.reader.swing;

import java.awt.Graphics;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;

import net.sf.sqs_xml.image.RasterSource;


class ImagePanel extends JPanel{
    BufferedImage image = null;
    ImagePanel(RasterSource source){
        this.image = RasterSource.createImage(source.getRaster());
    }
    public void paint(Graphics g){
        g.drawImage(image, 0, 0, this);
    }
}