/*

 Calendar.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/06/30

 */
package net.sf.sqs_xml.swing;

import java.util.Calendar;

import javax.swing.JPanel;

import javax.swing.JList;
import javax.swing.JLabel;

/**
 * @author hiroya
 *
 */
public class CalendarEditor extends JPanel {

	private JList jList = null;
	private JList jList1 = null;
	private JList jList2 = null;
	/**
	 * This is the default constructor
	 */
	public CalendarEditor() {
		super();
		initialize();
	}
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private  void initialize() {
		javax.swing.JLabel jLabel2 = new JLabel();
		javax.swing.JLabel jLabel1 = new JLabel();
		javax.swing.JLabel jLabel = new JLabel();
		this.setSize(175, 24);
		jLabel.setText("年");
		jLabel1.setText("月");
		jLabel2.setText("日");
		this.add(getJList(), null);
		this.add(jLabel, null);
		this.add(getJList1(), null);
		this.add(jLabel1, null);
		this.add(getJList2(), null);
		this.add(jLabel2, null);
	}
	/**
	 * This method initializes jList	
	 * 	
	 * @return javax.swing.JList	
	 */    
	private JList getJList() {
		if (jList == null) {
		    Calendar calendar = Calendar.getInstance();
		    int start = calendar.get(Calendar.YEAR) - 10;
		    int end = start + 10;
		    Integer[] years = new Integer[end - start + 1];
		    for(int i=0; i<years.length; i++){
		        years[i] = new Integer(start+i);
		    }
			jList = new JList(years);
			jList.setVisibleRowCount(1);
			jList.setPreferredSize(new java.awt.Dimension(48,12));
			jList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
		}
		return jList;
	}
	/**
	 * This method initializes jList1	
	 * 	
	 * @return javax.swing.JList	
	 */    
	private JList getJList1() {
		if (jList1 == null) {
		    Integer[] months = new Integer[12];
		    for(int i=0; i<months.length; i++){
		        months[i] = new Integer(i+1);
		    }
			jList1 = new JList(months);
			jList1.setPreferredSize(new java.awt.Dimension(24,12));
			jList1.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
			jList1.setVisibleRowCount(1);
		}
		return jList1;
	}
	/**
	 * This method initializes jList2	
	 * 	
	 * @return javax.swing.JList	
	 */    
	private JList getJList2() {
		if (jList2 == null) {
		    Integer[] days = new Integer[31];
		    for(int i=0; i<days.length; i++){
		        days[i] = new Integer(i+1);
		    }		    
			jList2 = new JList(days);
			jList2.setVisibleRowCount(1);
			jList2.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
			jList2.setPreferredSize(new java.awt.Dimension(24,12));
		}
		return jList2;
	}
   }  //  @jve:decl-index=0:visual-constraint="10,10"
