/*
 * 
 * 
 * Copyright 2004 SQS Development Team / Community Management Research
 * Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package net.sf.sqs_xml.translator.servlet;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;

import net.sf.sqs_xml.translator.logic.SQStoPDFTranslator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;

import org.apache.avalon.framework.logger.NullLogger;

public class SQStoPDFServlet extends GenericTranslationServlet {
	SQStoPDFTranslator logic;
	public SQStoPDFServlet() throws Exception {
		this.logic = new SQStoPDFTranslator();
	}

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	public void perform(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException, TransformerException {
		try {
			String fileNameBody = (String) req.getAttribute("fileNameBody");
			java.io.InputStream sqsInputStream = (java.io.InputStream) req.getAttribute("fileInputStream");
			ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
			((SQStoPDFTranslator) logic).translate(sqsInputStream, new TranslatorResource(new NullLogger()), out, null);//TODO
			res.setContentLength(out.size());
			
			res.setContentType("application/pdf");
			res.setHeader(
					"Content-Disposition:",
					"attachment; filename=" + fileNameBody + ".pdf");
			out.writeTo(res.getOutputStream());
			out.flush();
			out.close();
			res.getOutputStream().flush();
			res.getOutputStream().close();
		} catch (FileNotFoundException e) {
			throw new ServletException(e);
		} catch (TranslatorException e) {
			throw new ServletException(e);
		} catch (java.io.IOException e) {
			throw new ServletException(e);
		}
	}
}
