/*

 DOMUtil.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/06

 */
package net.sf.sqs_xml.util;

import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author hiroya
 *
 */
public class DOMUtil {
    public static Element getElement(Element node, String[][] args){
        Element current = node;
        for(int i = 0; i < args.length; i++){
            String[] arg = args[i];
            String nsURI = arg[0];
            String localName = arg[1];
            current = (Element)getElementList(current, nsURI, localName).item(0); 
        }
        return current;
    }
    
    public static Element getElement(Element node, String nsURI, String localName){
        return (Element)getElementList(node, nsURI, localName).item(0);
    }
    
    public static NodeList getElementList(Element node, String nsURI, String localName){
        return node.getElementsByTagNameNS(nsURI, localName);
    }

	public static String stringValueOf(Document document, Node node, String xpathString){
        try {
            Node target = XPathAPI.selectSingleNode(node, xpathString, document);
            if(target == null){
                return null;
            }
            
            if(target.getNodeType()==Node.TEXT_NODE){
                return target.getNodeValue();
            }else if(target.getNodeType()==Node.ATTRIBUTE_NODE){
                return ((Attr)target).getValue();
            }else{
                System.err.println("ERROR Type:unknown"+target.getNodeType());
                System.err.println("ERROR Node:"+node);
                System.err.println("ERROR XPath:"+xpathString);
                return null;
            }
        } catch (DOMException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

	public static Integer integerValueOf(Document document, Element node, String xpathString){
        return new Integer(intValueOf(document, node, xpathString));
    }

    public static Double doubleValueOf(Document document, Element node, String xpathString){
        String value = stringValueOf(document, node, xpathString);
        if(value == null){
            throw new NullPointerException();
        }
        return new Double(Double.parseDouble(value));
    }
    
    public static int intValueOf(Document document, Element node, String xpathString){
        return Integer.parseInt(stringValueOf(document, node, xpathString));
    }

    public static void setNodeValue(Document document, Node node, String xpathString, String value){
        try {
            Node target = XPathAPI.selectSingleNode(node, xpathString, document);                     
            if(target == null){  
                if(xpathString.endsWith("text()")){
                    node.appendChild(document.createTextNode(value));
                }else{
                    System.err.println("ERROR Node:"+node);
                    System.err.println("ERROR XPath:"+xpathString);
                }
                return;
            }
            
            if(target.getNodeType()==Node.TEXT_NODE){
                target.setNodeValue(value);
            }else if(target.getNodeType()==Node.ATTRIBUTE_NODE){
                ((Attr)target).setValue(value);
            }else{
                System.err.println("ERROR Type:unknown"+target.getNodeType());
                System.err.println("ERROR Node:"+node);
                System.err.println("ERROR XPath:"+xpathString);
            }
        } catch (DOMException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static void setAttributeValue(Document document, Element node, String xpathString, String uri, String prefix, String name, String value){
        try {
            Node target = XPathAPI.selectSingleNode(node, xpathString, document);
            if(target == null){
                System.err.println("ERROR Node:"+node);
                System.err.println("ERROR XPath:"+xpathString);
                return;
            }
            
            if(target.getNodeType() == Node.ELEMENT_NODE){
                Element elem = ((Element)target);
                Attr attr;
                if(elem.hasAttributeNS(uri, name)){
                    attr = elem.getAttributeNodeNS(uri, name);
                    attr.setNodeValue(value);
                    attr.setPrefix(prefix);
                    //elem.setAttributeNS(uri, name, value);                    
                }else{
                    attr = document.createAttributeNS(uri, name);
                    attr.setNodeValue(value);
                    attr.setPrefix(prefix);
                    elem.setAttributeNodeNS(attr);
                    //elem.setAttributeNS(uri, name, value);                    
                }
            }else{
                System.err.println("ERROR Type:unknown"+target.getNodeType());
                System.err.println("ERROR Node:"+node);
                System.err.println("ERROR XPath:"+xpathString);
                return;
            }
        } catch (DOMException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}
