/*

 JNLPBrowserLauncher.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/01

 */
package net.sf.sqs_xml.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.jnlp.BasicService;

/**
 * @author hiroya
 *
 */
public class JNLPBrowserLauncher implements BrowserLauncher{
    BasicService basicService = null;
    public JNLPBrowserLauncher(BasicService basicService) {
        this.basicService = basicService;
    }
    public void showDocument(URL url)throws IOException{
        basicService.showDocument(url);
    }
    public void showDocument(String url)throws IOException{
        basicService.showDocument(new URL(url));
    }
    public void showDocument(File file)throws IOException{
        basicService.showDocument(file.toURI().toURL());
        //basicService.showDocument(FileUtil.toURL(file));
    }
}