<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs" xmlns:svg="http://www.w3.org/2000/svg" version="1.0">
	<xsl:param name="example-blank-mark-label"/>
	<xsl:param name="example-filled-mark-label"/>
	<xsl:param name="example-incomplete-mark-label"/>

	<xsl:template match="sqs:marking-example">
		<fo:table table-layout="fixed" padding-left="50px" margin-left="50px" padding-top="0px" padding-bottom="15px">
			<fo:table-column column-width="80px"/>
			<fo:table-column column-width="14px"/>
			<fo:table-column column-width="120px"/>
			<fo:table-column column-width="14px"/>
			<fo:table-column column-width="130px"/>
			<fo:table-column column-width="14px"/>
			<fo:table-column column-width="130px"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell/>
					<fo:table-cell>
						<fo:block padding-left="0px" border-left="0px" margin-left="0px">
							<fo:instream-foreign-object>
								<xsl:call-template name="mark"/>
							</fo:instream-foreign-object>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block font-family="Mincho" font-size="10pt" margin-left="0px" margin-right="0px">
						<xsl:value-of select="$example-blank-mark-label"/>
          </fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block padding-left="0px" border-left="0px" margin-left="0px">
							<fo:instream-foreign-object>
								<xsl:call-template name="mark-filled"/>
							</fo:instream-foreign-object>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block font-family="Mincho" font-size="10pt" margin-left="0px" margin-right="0px">
         <xsl:value-of select="$example-filled-mark-label"/>
          </fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block padding-left="0px" border-left="0px" margin-left="0px">
							<fo:instream-foreign-object>
								<xsl:call-template name="bad-mark"/>
							</fo:instream-foreign-object>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block font-family="Mincho" font-size="10pt" margin-left="0px" margin-right="0px">
          <xsl:value-of select="$example-incomplete-mark-label"/>
          </fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="bad-mark">
		<xsl:variable name="width">
			<xsl:value-of select="number(4)"/>
		</xsl:variable>
		<xsl:variable name="height">
			<xsl:value-of select="number(16)"/>
		</xsl:variable>
		<xsl:element name="svg:svg">
			<xsl:attribute name="width"><xsl:value-of select="8"/></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
			<xsl:call-template name="generic-mark-core">
				<xsl:with-param name="width"><xsl:value-of select="$width"/></xsl:with-param>
				<xsl:with-param name="height"><xsl:value-of select="$height"/></xsl:with-param>
			</xsl:call-template>
			<svg:g style="stroke:black; fill:black; stroke-width=0.3pt">
				<svg:path d="M 2.5 10.5 L 8 1 Z"/>
				<svg:path d="M 2.5 10.5 L 1 5 Z"/>
			</svg:g>
		</xsl:element>
	</xsl:template>
	<xsl:template match="sqs:mark">
		<fo:inline padding-left="0px" border-left="0px" margin-left="0px">
			<fo:instream-foreign-object>
				<xsl:call-template name="mark"/>
			</fo:instream-foreign-object>
		</fo:inline>
	</xsl:template>
</xsl:stylesheet>
