<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs" exclude-result-prefixes="sqs xforms" version="1.0">
	<xsl:template name="xforms:ref">
		<xsl:choose>
			<xsl:when test="0 = string-length(@xforms:ref)">a[<xsl:number level="any" from="/" count="xforms:select | xforms:select1 | xforms:input | xforms:textarea | xforms:range" format="1"/>]</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="@xforms:ref"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="xforms:select1">
		<xsl:variable name="ref">
			<xsl:call-template name="xforms:ref"/>
		</xsl:variable>
		<xsl:for-each select="xforms:item">
			<input type="radio" name="{$ref}" value="{xforms:value}"/>
			<xsl:value-of select="xforms:value"/>: <xsl:for-each select="xforms:label"><xsl:apply-templates/></xsl:for-each>
			<br/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="xforms:select">
		<xsl:variable name="ref">
			<xsl:call-template name="xforms:ref"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="0 &lt; string-length(@sqs:pxform-type)">
				<xsl:for-each select="xforms:item">
					<input type="checkbox" name="{$ref}" value="true"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="xforms:item">
					<input type="checkbox" name="{$ref}/v{xforms:value}" value="true"/>
					<xsl:value-of select="xforms:value"/>: <xsl:for-each select="xforms:label"><xsl:apply-templates/></xsl:for-each>
					<br/>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="xforms:input">
		<xsl:variable name="ref">
			<xsl:call-template name="xforms:ref"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="0 &lt; string-length(@sqs:width)">
				<input type="text" name="{$ref}" value="{xforms:value}" size="{ceiling(number(@sqs:width) div 14)}"/>
			</xsl:when>
			<xsl:otherwise>
				<input type="text" name="{$ref}" value="{xforms:value}"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="xforms:textarea">
		<xsl:variable name="ref">
			<xsl:call-template name="xforms:ref"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="0 &lt; string-length(@sqs:width)">
				<textarea name="{$ref}" cols="{ceiling(number(@sqs:width) div 14)}" rows="{ceiling(number(@sqs:height) div 14)}"><xsl:text> </xsl:text></textarea>
			</xsl:when>
			<xsl:otherwise>
				<textarea name="{$ref}"><xsl:text> </xsl:text></textarea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
