/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.modules.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.EditorUtil;
import net.sf.sqs_xml.editor.base.modules.UpdateListener;
import net.sf.sqs_xml.editor.base.modules.UpdateTarget;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractNodeEditorPanel;
import net.sf.sqs_xml.editor.sqs.modules.panel.SelectFormItemListModel;
import org.w3c.dom.Element;

public class SelectFormItemListPanel
extends AbstractNodeEditorPanel
implements UpdateTarget {
    SelectFormItemListModel model;
    Item[] itemList = null;
    Icon itemIcon;
    Box itemListFormInnerPane;
    SelectFormItemListPanel self = this;

    public SelectFormItemListPanel(AbstractNodeEditor editor) {
        super(editor);
        this.model = new SelectFormItemListModel(editor.getMediator(), editor.getSource(), (Element)editor.getNode());
        this.itemIcon = editor.getMediator().getCurrentTreePane().getIcon("item", "http://www.w3.org/2002/xforms");
        this.itemListFormInnerPane = Box.createVerticalBox();
        JPanel itemListForm = new JPanel();
        itemListForm.setBorder(new TitledBorder(EditorUtil.LOWERED_BORDER, "\u9078\u629e\u80a2"));
        itemListForm.setBackground(editor.getResource().bgcolor);
        itemListForm.setLayout(new BorderLayout());
        itemListForm.add((Component)this.createItemListScrollPanel(), "Center");
        this.setBackground(editor.getResource().bgcolor);
        this.add(itemListForm);
        this.initialize();
        this.initSize();
    }

    public int getPreferredHeight() {
        return 40;
    }

    private JScrollPane createItemListScrollPanel() {
        final JScrollPane itemListFormScrollPane = new JScrollPane(this.itemListFormInnerPane);
        itemListFormScrollPane.setWheelScrollingEnabled(true);
        itemListFormScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ev) {
                if (itemListFormScrollPane != null && SelectFormItemListPanel.this.model != null) {
                    int increment = SelectFormItemListPanel.this.itemListFormInnerPane.getHeight() / SelectFormItemListPanel.this.model.size();
                    itemListFormScrollPane.getVerticalScrollBar().setUnitIncrement(increment);
                }
            }
        });
        return itemListFormScrollPane;
    }

    public synchronized void initialize() {
        this.itemListFormInnerPane.removeAll();
        this.itemList = new Item[this.model.size()];
        int i = 0;
        while (i < this.model.size()) {
            Item item;
            this.itemList[i] = item = new Item(this, i);
            this.itemListFormInnerPane.add(item);
            ++i;
        }
    }

    public synchronized Item get(int index) {
        return this.itemList[index];
    }

    public boolean updateNodeValue() {
        boolean isUpdated = false;
        int i = 0;
        while (i < this.itemList.length) {
            if (this.itemList[i].updateNodeValue()) {
                isUpdated = true;
            }
            ++i;
        }
        if (isUpdated) {
            this.getEditor().updateNodeValue(true);
        }
        return isUpdated;
    }

    public class Item
    extends JPanel {
        PopupMenu popupMenu;
        int index;
        JTextField valueTextField;
        JTextField labelTextField;
        JSpinner colspanSpinner;
        JComponent itemFormWest;
        JComponent itemFormEast;
        UpdateListener updateListener;

        Item(AbstractNodeEditorPanel itemListForm, int index) {
            this.index = index;
            this.updateListener = new UpdateListener(SelectFormItemListPanel.this.self);
            this.popupMenu = new PopupMenu(index);
            this.setLayout(new BorderLayout());
            this.setBackground(SelectFormItemListPanel.this.getEditor().getResource().bgcolor);
            this.itemFormWest = this.createFormItemWest();
            this.add((Component)this.itemFormWest, "West");
            this.labelTextField = this.createFormItemCenter();
            this.add((Component)this.labelTextField, "Center");
            this.itemFormEast = this.createFormItemEast();
            this.add((Component)this.itemFormEast, "East");
            this.setPreferredSize(new Dimension(340, 20));
            this.setSize(new Dimension(340, 20));
            this.addMouseListener(this.popupMenu.getMouseListener());
        }

        public void setSelectedBackGroundColor(boolean isSelected) {
            if (isSelected) {
                this.setBackground(SelectFormItemListPanel.this.getEditor().getResource().bgcolor.brighter());
            } else {
                this.setBackground(SelectFormItemListPanel.this.getEditor().getResource().bgcolor);
            }
        }

        JTextField getLabelTextField() {
            return this.labelTextField;
        }

        public boolean updateNodeValue() {
            return SelectFormItemListPanel.this.model.updateNodeValue(this.index, this.labelTextField.getText(), this.valueTextField.getText(), (Integer)this.colspanSpinner.getValue());
        }

        private JComponent createFormItemWest() {
            this.valueTextField = new JTextField();
            this.valueTextField.setSize(2, 1);
            this.valueTextField.setText(SelectFormItemListPanel.this.model.getValue(this.index));
            this.valueTextField.setBackground(this.getBackground());
            this.valueTextField.setEditable(true);
            this.valueTextField.addFocusListener(this.updateListener);
            this.valueTextField.setPreferredSize(new Dimension(16, 14));
            Box itemFormWest = Box.createHorizontalBox();
            itemFormWest.add(new JLabel(SelectFormItemListPanel.this.itemIcon));
            itemFormWest.add(this.valueTextField);
            itemFormWest.add(new JLabel(":"));
            if (SelectFormItemListPanel.this.getEditor().getSource().isReadOnly()) {
                this.valueTextField.setEnabled(false);
            }
            return itemFormWest;
        }

        private JTextField createFormItemCenter() {
            this.labelTextField = new JTextField();
            this.labelTextField.setSize(10, 1);
            this.labelTextField.setText(SelectFormItemListPanel.this.model.getLabel(this.index));
            this.labelTextField.addFocusListener(this.updateListener);
            if (SelectFormItemListPanel.this.getEditor().getSource().isReadOnly()) {
                this.labelTextField.setEnabled(false);
            }
            return this.labelTextField;
        }

        private JComponent createFormItemEast() {
            this.colspanSpinner = new JSpinner(new SpinnerNumberModel(SelectFormItemListPanel.this.model.getColspan(this.index), 1, 9, 1));
            this.colspanSpinner.addChangeListener(this.updateListener);
            Box colspanForm = EditorUtil.createSpinnerForm("/\u8868\u793a\u5e45:", this.colspanSpinner);
            this.colspanSpinner.setSize(1, 1);
            Box itemFormEast = Box.createHorizontalBox();
            itemFormEast.add(colspanForm);
            if (SelectFormItemListPanel.this.getEditor().getSource().isReadOnly()) {
                this.colspanSpinner.setEnabled(false);
            }
            return itemFormEast;
        }

        class PopupMenu
        extends JPopupMenu {
            private PopupAdapter listener;
            private JMenuItem deleteButton;
            private MouseAdapter mouseAdapter = new MouseAdapter(this){
                final /* synthetic */ PopupMenu this$2;
                {
                    this.this$2 = popupMenu;
                }

                public void mouseEntered(MouseEvent e) {
                    PopupMenu.access$0(this.this$2).setSelectedBackGroundColor(true);
                }

                public void mouseExited(MouseEvent e) {
                    PopupMenu.access$0(this.this$2).setSelectedBackGroundColor(false);
                }
            };

            PopupMenu(int index) {
                this.setPopupSize(300, 70);
                this.addMouseListener(this.mouseAdapter);
                this.listener = new PopupAdapter(this);
                JMenuItem insertBeforeButton = this.createPopupMenuItem("\u3053\u306e\u9078\u629e\u80a2\u306e\u300c\u524d\u300d\u306b\u65b0\u3057\u3044\u9078\u629e\u80a2\u3092\u633f\u5165", "b " + index);
                JMenuItem insertAfterButton = this.createPopupMenuItem("\u3053\u306e\u9078\u629e\u80a2\u306e\u300c\u5f8c\u300d\u306b\u65b0\u3057\u3044\u9078\u629e\u80a2\u3092\u633f\u5165", "a " + index);
                this.deleteButton = this.createPopupMenuItem("\u3053\u306e\u9078\u629e\u80a2\u3092\u524a\u9664", "d " + index);
                this.add(insertBeforeButton);
                this.add(insertAfterButton);
                this.addSeparator();
                this.add(this.deleteButton);
            }

            private JMenuItem createPopupMenuItem(String label, String command) {
                JMenuItem item = new JMenuItem(label);
                item.setActionCommand(command);
                item.addActionListener(this.listener);
                item.addMouseListener(this.mouseAdapter);
                return item;
            }

            MouseAdapter getMouseListener() {
                return this.listener;
            }

            public JMenuItem getDeleteButton() {
                return this.deleteButton;
            }

            class PopupAdapter
            extends MouseAdapter
            implements ActionListener {
                private JPopupMenu popupMenu;

                PopupAdapter(JPopupMenu commandPopup) {
                    this.popupMenu = commandPopup;
                }

                public void actionPerformed(ActionEvent ev) {
                    String[] commandArgs = ev.getActionCommand().split("\\s");
                    String command = commandArgs[0];
                    int target = Integer.parseInt(commandArgs[1]);
                    if (command.equals("d")) {
                        this.delete(target);
                    } else if (command.equals("b")) {
                        this.insertBefore(target);
                    } else if (command.equals("a")) {
                        this.insertAfter(target);
                    } else {
                        return;
                    }
                    Item.this.setSelectedBackGroundColor(false);
                    SelectFormItemListPanel.this.initialize();
                    if (command.equals("b")) {
                        SelectFormItemListPanel.this.get(target).getLabelTextField().requestFocus();
                    } else if (command.equals("a")) {
                        SelectFormItemListPanel.this.get(target + 1).getLabelTextField().requestFocus();
                    }
                    SelectFormItemListPanel.this.getEditor().updateNodeValue(true);
                    SelectFormItemListPanel.this.getEditor().updateUI();
                    SelectFormItemListPanel.this.getEditor().getMediator().getCurrentTreePane().updateUI();
                }

                private void insertAfter(int target) {
                    if (target == ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.size() - 1) {
                        ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.add("", "", 1);
                    } else {
                        ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.insert(target + 1, "", "", 1);
                    }
                    PopupMenu.this.getDeleteButton().setEnabled(true);
                }

                private void insertBefore(int target) {
                    ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.insert(target, "", "", 1);
                    PopupMenu.this.getDeleteButton().setEnabled(true);
                }

                private void delete(int target) {
                    if (1 < ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.size()) {
                        ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.remove(target);
                        if (((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.size() == 1) {
                            PopupMenu.this.getDeleteButton().setEnabled(false);
                        }
                    }
                }

                public void mousePressed(MouseEvent e) {
                    Item.this.setSelectedBackGroundColor(true);
                    this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                    Item.this.setSelectedBackGroundColor(true);
                }

                public void mouseExited(MouseEvent e) {
                    if (!this.popupMenu.isVisible()) {
                        Item.this.setSelectedBackGroundColor(false);
                    }
                }
            }
        }
    }
}

