/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ReaderIndexMapper {
    Map errorAreaMap = new LinkedHashMap();
    Map validFileIndexToRealFileIndexMap = new HashMap();
    Map realFileIndexToValidFileIndexMap = new HashMap();
    int numErrorPages;
    int numErrorMarkSets;

    public int getValidFileIndexSize() {
        return this.validFileIndexToRealFileIndexMap.size();
    }

    public void addErrorArea(int validFileIndex, int page, String qid) {
        Integer index = new Integer(validFileIndex);
        LinkedList<Object[]> list = (LinkedList<Object[]>)this.errorAreaMap.get(index);
        if (list == null) {
            list = new LinkedList<Object[]>();
            this.errorAreaMap.put(index, list);
        }
        list.add(new Object[]{new Integer(page), qid});
    }

    public Set getErrorAreaEntrySet() {
        return this.errorAreaMap.entrySet();
    }

    public void reset() {
        this.errorAreaMap.clear();
        this.validFileIndexToRealFileIndexMap.clear();
        this.realFileIndexToValidFileIndexMap.clear();
        this.numErrorPages = 0;
        this.numErrorMarkSets = 0;
    }

    public void addRealValidFileIndex(int realValidFileIndex) {
        Integer realFileIndexObject = new Integer(realValidFileIndex);
        Integer validFileIndexObject = new Integer(this.validFileIndexToRealFileIndexMap.size());
        this.validFileIndexToRealFileIndexMap.put(validFileIndexObject, realFileIndexObject);
        this.realFileIndexToValidFileIndexMap.put(realFileIndexObject, validFileIndexObject);
    }

    public boolean isValidFileIndex(int realFileIndex) {
        return this.realFileIndexToValidFileIndexMap.containsKey(new Integer(realFileIndex));
    }

    public int getRealFileIndex(int validFileIndex) {
        return (Integer)this.validFileIndexToRealFileIndexMap.get(new Integer(validFileIndex));
    }

    public int getValidFileIndex(int realFileIndex) {
        return (Integer)this.realFileIndexToValidFileIndexMap.get(new Integer(realFileIndex));
    }

    public void incrementNumErrorPages() {
        ++this.numErrorPages;
    }

    public void incrementNumErrorMarkSets() {
        ++this.numErrorMarkSets;
    }

    public void setNumErrorPages(int numErrorPages) {
        this.numErrorPages = numErrorPages;
    }

    public int getNumErrorPages() {
        return this.numErrorPages;
    }

    public int getNumErrorMarkSets() {
        return this.numErrorMarkSets;
    }
}

