/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RelativePositionProps;

public class TableCell
extends FObj {
    String id;
    int numColumnsSpanned;
    int numRowsSpanned;
    int iColNumber = -1;
    protected int startOffset;
    protected int width;
    protected int beforeOffset = 0;
    protected int startAdjust = 0;
    protected int widthAdjust = 0;
    protected int borderHeight = 0;
    protected int minCellHeight = 0;
    protected int height = 0;
    protected int top;
    protected int verticalAlign;
    protected boolean bRelativeAlign = false;
    boolean bSepBorders = true;
    boolean bDone = false;
    int m_borderSeparation = 0;
    AreaContainer cellArea;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public TableCell(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (!(parent instanceof TableRow)) {
            throw new FOPException("A table cell must be child of fo:table-row, not " + parent.getName(), systemId, line, column);
        }
        this.doSetup();
    }

    public String getName() {
        return "fo:table-cell";
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getColumnNumber() {
        return this.iColNumber;
    }

    public int getNumColumnsSpanned() {
        return this.numColumnsSpanned;
    }

    public int getNumRowsSpanned() {
        return this.numRowsSpanned;
    }

    public void doSetup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.iColNumber = this.properties.get("column-number").getNumber().intValue();
        if (this.iColNumber < 0) {
            this.iColNumber = 0;
        }
        this.numColumnsSpanned = this.properties.get("number-columns-spanned").getNumber().intValue();
        if (this.numColumnsSpanned < 1) {
            this.numColumnsSpanned = 1;
        }
        this.numRowsSpanned = this.properties.get("number-rows-spanned").getNumber().intValue();
        if (this.numRowsSpanned < 1) {
            this.numRowsSpanned = 1;
        }
        this.id = this.properties.get("id").getString();
        this.bSepBorders = this.properties.get("border-collapse").getEnum() == 102;
        this.calcBorders(this.propMgr.getBorderAndPadding());
        this.verticalAlign = this.properties.get("display-align").getEnum();
        if (this.verticalAlign == 8) {
            this.bRelativeAlign = true;
            this.verticalAlign = this.properties.get("relative-align").getEnum();
        } else {
            this.bRelativeAlign = false;
        }
        this.minCellHeight = this.properties.get("height").getLength().mvalue();
    }

    public int layout(Area area) throws FOPException {
        int originalAbsoluteHeight = area.getAbsoluteHeight();
        if (this.marker == -1001) {
            return 1;
        }
        if (this.marker == -1000) {
            try {
                area.getIDReferences().createID(this.id);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
            this.marker = 0;
            this.bDone = false;
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        int spaceLeft = area.spaceLeft() - this.m_borderSeparation;
        this.cellArea = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), this.startOffset + this.startAdjust, this.beforeOffset, this.width - this.widthAdjust, spaceLeft, 88);
        this.cellArea.foCreator = this;
        this.cellArea.setPage(area.getPage());
        this.cellArea.setParent(area);
        try {
            this.cellArea.setBorderAndPadding((BorderAndPadding)this.propMgr.getBorderAndPadding().clone());
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Can't clone BorderAndPadding: " + e);
            this.cellArea.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        }
        this.cellArea.setBackground(this.propMgr.getBackgroundProps());
        this.cellArea.start();
        this.cellArea.setAbsoluteHeight(area.getAbsoluteHeight());
        this.cellArea.setIDReferences(area.getIDReferences());
        this.cellArea.setTableCellXOffset(this.startOffset + this.startAdjust);
        int numChildren = this.children.size();
        int i = this.marker;
        while (!this.bDone && i < numChildren) {
            FObj fo = (FObj)this.children.get(i);
            fo.setIsInTableCell();
            fo.forceWidth(this.width);
            this.marker = i++;
            int status = fo.layout(this.cellArea);
            if (Status.isIncomplete(status)) {
                if (i == 0 && status == 2) {
                    return 2;
                }
                area.addChild(this.cellArea);
                return 3;
            }
            area.setMaxHeight(area.getMaxHeight() - spaceLeft + this.cellArea.getMaxHeight());
        }
        this.bDone = true;
        this.cellArea.end();
        area.addChild(this.cellArea);
        if (this.minCellHeight > this.cellArea.getContentHeight()) {
            this.cellArea.setHeight(this.minCellHeight);
        }
        this.height = this.cellArea.getHeight();
        this.top = this.cellArea.getCurrentYPosition();
        return 1;
    }

    public int getHeight() {
        return this.cellArea.getHeight() + this.m_borderSeparation - this.borderHeight;
    }

    public void setRowHeight(int h) {
        int delta = h - this.getHeight();
        if (this.bRelativeAlign) {
            this.cellArea.increaseHeight(delta);
        } else if (delta > 0) {
            BorderAndPadding cellBP = this.cellArea.getBorderAndPadding();
            switch (this.verticalAlign) {
                case 16: {
                    this.cellArea.shiftYPosition(delta / 2);
                    cellBP.setPaddingLength(0, cellBP.getPaddingTop(false) + delta / 2);
                    cellBP.setPaddingLength(2, cellBP.getPaddingBottom(false) + delta - delta / 2);
                    break;
                }
                case 2: {
                    cellBP.setPaddingLength(0, cellBP.getPaddingTop(false) + delta);
                    this.cellArea.shiftYPosition(delta);
                    break;
                }
                case 10: {
                    cellBP.setPaddingLength(2, cellBP.getPaddingBottom(false) + delta);
                }
            }
        }
    }

    private void calcBorders(BorderAndPadding bp) {
        if (this.bSepBorders) {
            int iSep = this.properties.get("border-separation.inline-progression-direction").getLength().mvalue();
            int iSpacing = this.properties.get("border-spacing.inline-progression-direction").getLength().mvalue();
            if (iSpacing > iSep) {
                iSep = iSpacing;
            }
            this.startAdjust = iSep / 2 + bp.getBorderLeftWidth(false) + bp.getPaddingLeft(false);
            this.widthAdjust = this.startAdjust + iSep - iSep / 2 + bp.getBorderRightWidth(false) + bp.getPaddingRight(false);
            this.m_borderSeparation = this.properties.get("border-separation.block-progression-direction").getLength().mvalue();
            int m_borderSpacing = this.properties.get("border-spacing.block-progression-direction").getLength().mvalue();
            if (m_borderSpacing > this.m_borderSeparation) {
                this.m_borderSeparation = m_borderSpacing;
            }
            this.beforeOffset = this.m_borderSeparation / 2 + bp.getBorderTopWidth(false) + bp.getPaddingTop(false);
        } else {
            int borderStart = bp.getBorderLeftWidth(false);
            int borderEnd = bp.getBorderRightWidth(false);
            int borderBefore = bp.getBorderTopWidth(false);
            int borderAfter = bp.getBorderBottomWidth(false);
            this.startAdjust = borderStart / 2 + bp.getPaddingLeft(false);
            this.widthAdjust = this.startAdjust + borderEnd / 2 + bp.getPaddingRight(false);
            this.beforeOffset = borderBefore / 2 + bp.getPaddingTop(false);
            this.borderHeight = (borderBefore + borderAfter) / 2;
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new TableCell(parent, propertyList, systemId, line, column);
        }
    }
}

