/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGGVTFont;
import org.apache.batik.gvt.font.Kern;
import org.apache.batik.gvt.font.UnicodeRange;
import org.w3c.dom.Element;

public abstract class SVGKernElementBridge
extends AbstractSVGBridge {
    public Kern createKern(BridgeContext ctx, Element kernElement, SVGGVTFont font) {
        int i;
        int[] glyphCodes;
        String token;
        String u1 = kernElement.getAttributeNS(null, "u1");
        String u2 = kernElement.getAttributeNS(null, "u2");
        String g1 = kernElement.getAttributeNS(null, "g1");
        String g2 = kernElement.getAttributeNS(null, "g2");
        String k = kernElement.getAttributeNS(null, "k");
        if (k.length() == 0) {
            k = "0";
        }
        float kernValue = Float.parseFloat(k);
        Vector<Integer> firstGlyphSet = new Vector<Integer>();
        Vector<Integer> secondGlyphSet = new Vector<Integer>();
        Vector<UnicodeRange> firstUnicodeRanges = new Vector<UnicodeRange>();
        Vector<UnicodeRange> secondUnicodeRanges = new Vector<UnicodeRange>();
        StringTokenizer st = new StringTokenizer(u1, ",");
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.startsWith("U+")) {
                firstUnicodeRanges.add(new UnicodeRange(token));
                continue;
            }
            glyphCodes = font.getGlyphCodesForUnicode(token);
            i = 0;
            while (i < glyphCodes.length) {
                firstGlyphSet.add(new Integer(glyphCodes[i]));
                ++i;
            }
        }
        st = new StringTokenizer(u2, ",");
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.startsWith("U+")) {
                secondUnicodeRanges.add(new UnicodeRange(token));
                continue;
            }
            glyphCodes = font.getGlyphCodesForUnicode(token);
            i = 0;
            while (i < glyphCodes.length) {
                secondGlyphSet.add(new Integer(glyphCodes[i]));
                ++i;
            }
        }
        st = new StringTokenizer(g1, ",");
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            glyphCodes = font.getGlyphCodesForName(token);
            i = 0;
            while (i < glyphCodes.length) {
                firstGlyphSet.add(new Integer(glyphCodes[i]));
                ++i;
            }
        }
        st = new StringTokenizer(g2, ",");
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            glyphCodes = font.getGlyphCodesForName(token);
            i = 0;
            while (i < glyphCodes.length) {
                secondGlyphSet.add(new Integer(glyphCodes[i]));
                ++i;
            }
        }
        int[] firstGlyphs = new int[firstGlyphSet.size()];
        int[] secondGlyphs = new int[secondGlyphSet.size()];
        UnicodeRange[] firstRanges = new UnicodeRange[firstUnicodeRanges.size()];
        UnicodeRange[] secondRanges = new UnicodeRange[secondUnicodeRanges.size()];
        int i2 = 0;
        while (i2 < firstGlyphSet.size()) {
            firstGlyphs[i2] = (Integer)firstGlyphSet.elementAt(i2);
            ++i2;
        }
        int i3 = 0;
        while (i3 < secondGlyphSet.size()) {
            secondGlyphs[i3] = (Integer)secondGlyphSet.elementAt(i3);
            ++i3;
        }
        int i4 = 0;
        while (i4 < firstUnicodeRanges.size()) {
            firstRanges[i4] = (UnicodeRange)firstUnicodeRanges.elementAt(i4);
            ++i4;
        }
        int i5 = 0;
        while (i5 < secondUnicodeRanges.size()) {
            secondRanges[i5] = (UnicodeRange)secondUnicodeRanges.elementAt(i5);
            ++i5;
        }
        return new Kern(firstGlyphs, secondGlyphs, firstRanges, secondRanges, kernValue);
    }
}

