/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.source;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.tree.TreeModel;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.sqs_xml.editor.base.source.DOMTreeWalkerTreeModel;
import net.sf.sqs_xml.editor.base.source.Source;
import net.sf.sqs_xml.editor.base.source.SourceException;
import net.sf.sqs_xml.util.XMLUtil;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class DOMTreeSource
extends Source {
    Document document;
    DOMTreeWalkerTreeModel model;

    public DOMTreeSource() throws SourceException {
    }

    public DOMTreeSource(File file) throws SourceException {
        super(file);
    }

    public DOMTreeSource(URL url, boolean readonly, String title) throws SourceException {
        super(url, readonly, title);
    }

    public void initialize() throws SourceException {
        DOMImplementationImpl domImpl = new DOMImplementationImpl();
        DocumentType docType = domImpl.createDocumentType("html", "public ID", "system ID");
        this.document = domImpl.createDocument("http://www.w3.org/2002/06/xhtml2", "html", docType);
    }

    public void initialize(File file) throws SourceException {
        try {
            this.document = this.createDocument(file);
            this.model = this.createTreeModel(this.document);
        }
        catch (IOException e) {
            throw new SourceException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SourceException(e);
        }
        catch (SAXException e) {
            throw new SourceException(e);
        }
    }

    public void initialize(InputStream stream) throws SourceException {
        try {
            this.document = this.createDocument(stream);
            this.model = this.createTreeModel(this.document);
            stream.close();
        }
        catch (IOException e) {
            throw new SourceException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SourceException(e);
        }
        catch (SAXException e) {
            throw new SourceException(e);
        }
    }

    private DOMTreeWalkerTreeModel createTreeModel(Document document) {
        DOMImplementation domimpl = document.getImplementation();
        if (!domimpl.hasFeature("Traversal", "2.0")) {
            throw new RuntimeException("Traversal is not supported!");
        }
        DocumentTraversal traversal = (DocumentTraversal)((Object)document);
        NodeFilter filter = this.createNodeFilter();
        int whatToShow = -129;
        TreeWalker walker = traversal.createTreeWalker(document, whatToShow, filter, false);
        return new DOMTreeWalkerTreeModel(walker);
    }

    private NodeFilter createNodeFilter() {
        NodeFilter filter = new NodeFilter(){

            public short acceptNode(Node n) {
                if (n.getNodeType() == 3 && ((Text)n).getData().trim().length() == 0) {
                    return 2;
                }
                return 1;
            }
        };
        return filter;
    }

    public Document createDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtil.createParser().parse(file);
    }

    public Document createDocument(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtil.createParser().parse(stream);
    }

    public Document getDocument() {
        return this.document;
    }

    public TreeModel getTreeModel() {
        return this.model;
    }

    public InputStream createInputStream() throws IOException {
        return XMLUtil.createInputStream(this.document.getDocumentElement());
    }
}

