/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.tree.TreePath;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.ContainerEditor;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.swing.AbstractNodeTreePane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import net.sf.sqs_xml.editor.base.swing.TreeNodePopupMenu;
import org.w3c.dom.Node;

public abstract class NodeTreePane
extends AbstractNodeTreePane {
    SourceEditorMediator mediator;
    JComponent editorPane;
    Point mousePressCursorPoint = null;
    Point prevCursorPoint = null;
    Point currentCursorPoint = null;
    static final Color[] GUIDE_COLOR = new Color[]{new Color(120, 250, 120, 100), new Color(180, 180, 180, 200)};
    ArrayList editorHeightList = new ArrayList();

    public NodeTreePane(SourceEditorMediator mediator, DOMTreeSource source, JComponent editorPane) {
        super(source);
        this.mediator = mediator;
        this.editorPane = editorPane;
        this.setupEditorPane();
        this.addMouseListener(this.createMouseListener(editorPane));
        this.addMouseMotionListener(this.createMouseMotionListener());
    }

    private MouseMotionListener createMouseMotionListener() {
        return new MouseMotionListener(){

            public void mouseDragged(MouseEvent ev) {
                if (NodeTreePane.this.isSelectionModeMouseDragEvent(ev)) {
                    this.selectNodeGroup(ev);
                    this.dragViewportArea(ev);
                }
            }

            private void selectNodeGroup(MouseEvent ev) {
                NodeTreePane.this.currentCursorPoint = ev.getPoint();
                if (NodeTreePane.this.mousePressCursorPoint != null) {
                    int mousePressRow = NodeTreePane.this.getClosestRowForLocation(NodeTreePane.this.mousePressCursorPoint.x, NodeTreePane.this.mousePressCursorPoint.y);
                    int currentRow = NodeTreePane.this.getClosestRowForLocation(ev.getPoint().x, ev.getPoint().y);
                    if (NodeTreePane.this.isCtrlPressed(ev)) {
                        if (NodeTreePane.this.prevCursorPoint != null) {
                            NodeTreePane.this.selectionModel.xORSelection(mousePressRow, NodeTreePane.this.getClosestRowForLocation(NodeTreePane.this.prevCursorPoint.x, NodeTreePane.this.prevCursorPoint.y));
                        }
                        NodeTreePane.this.selectionModel.xORSelection(mousePressRow, currentRow);
                    } else {
                        NodeTreePane.this.selectionModel.clearSelection();
                        NodeTreePane.this.selectionModel.selectNodeGroup(mousePressRow, currentRow);
                    }
                }
                NodeTreePane.this.prevCursorPoint = NodeTreePane.this.currentCursorPoint;
            }

            private void dragViewportArea(MouseEvent ev) {
                JViewport viewport = (JViewport)NodeTreePane.this.getParent();
                Point viewPosition = viewport.getViewPosition();
                Point current = viewport.getViewPosition();
                if (viewPosition.x + viewport.getWidth() < ev.getPoint().x && viewport.getWidth() < NodeTreePane.this.getWidth() - viewPosition.x) {
                    current.translate(ev.getPoint().x - viewPosition.x - viewport.getWidth(), 0);
                } else if (ev.getPoint().x < viewPosition.x && viewPosition.x > 0) {
                    current.translate(ev.getPoint().x - viewPosition.x, 0);
                }
                if (viewPosition.y + viewport.getHeight() < ev.getPoint().y && viewport.getHeight() < NodeTreePane.this.getHeight() - viewPosition.y) {
                    current.translate(0, ev.getPoint().y - viewPosition.y - viewport.getHeight());
                } else if (ev.getPoint().y < viewPosition.y && viewPosition.y > 0) {
                    current.translate(0, ev.getPoint().y - viewPosition.y);
                }
                viewport.setViewPosition(current);
                viewport.updateUI();
            }

            public void mouseMoved(MouseEvent ev) {
            }
        };
    }

    private boolean isOutsideNodeRenderingAreaEvent(MouseEvent ev) {
        return this.getPathForLocation(ev.getPoint().x, ev.getPoint().y) == null;
    }

    private MouseAdapter createMouseListener(final JComponent editorPane) {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                if (NodeTreePane.this.isSelectionModeButtonPressEvent(ev) && NodeTreePane.this.isCtrlPressed(ev)) {
                    int currentRow = NodeTreePane.this.getClosestRowForLocation(ev.getPoint().x, ev.getPoint().y);
                    NodeTreePane.this.selectionModel.xORSelection(currentRow, currentRow);
                    NodeTreePane.this.setupEditorPane();
                    NodeTreePane.this.updateUI();
                }
            }

            public void mousePressed(MouseEvent ev) {
                if (NodeTreePane.this.isSelectionModeButtonPressEvent(ev)) {
                    if (NodeTreePane.this.isCtrlPressed(ev)) {
                        ev.consume();
                    } else if (!NodeTreePane.this.isOutsideNodeRenderingAreaEvent(ev)) {
                        NodeTreePane.this.selectionModel.clearSelection();
                        editorPane.removeAll();
                    }
                    NodeTreePane.this.mousePressCursorPoint = ev.getPoint();
                    NodeTreePane.this.prevCursorPoint = null;
                    NodeTreePane.this.currentCursorPoint = ev.getPoint();
                } else if (NodeTreePane.this.selectionModel.getSelectionCount() > 0) {
                    NodeTreePane.this.popup = NodeTreePane.this.createPopupMenu(NodeTreePane.this.getClosestRowForLocation(ev.getPoint().x, ev.getPoint().y));
                    NodeTreePane.this.popup.show(NodeTreePane.this.self, ev.getX(), ev.getY());
                }
            }

            public void mouseReleased(MouseEvent ev) {
                if (NodeTreePane.this.isSelectionModeButtonPressEvent(ev)) {
                    if (NodeTreePane.this.mousePressCursorPoint.equals(ev.getPoint()) && NodeTreePane.this.isOutsideNodeRenderingAreaEvent(ev)) {
                        NodeTreePane.this.mousePressCursorPoint = null;
                        NodeTreePane.this.prevCursorPoint = null;
                        NodeTreePane.this.currentCursorPoint = null;
                        return;
                    }
                    NodeTreePane.this.selectionModel.removeHierachicalSelected();
                    NodeTreePane.this.setupEditorPane();
                    NodeTreePane.this.mousePressCursorPoint = null;
                    NodeTreePane.this.prevCursorPoint = null;
                    NodeTreePane.this.currentCursorPoint = null;
                }
                NodeTreePane.this.updateUI();
            }

            private void selectNodeGroup(MouseEvent ev) {
                int currentRow = NodeTreePane.this.getClosestRowForLocation(ev.getPoint().x, ev.getPoint().y);
                if (!NodeTreePane.this.isCtrlPressed(ev)) {
                    NodeTreePane.this.selectionModel.selectNodeGroup(currentRow, 0);
                }
            }
        };
    }

    private boolean isSelectionModeButtonPressEvent(MouseEvent ev) {
        return this.isButton1Pressed(ev);
    }

    private boolean isSelectionModeMouseDragEvent(MouseEvent ev) {
        return this.isButton1Dragged(ev);
    }

    private boolean isButton1Dragged(MouseEvent ev) {
        return (ev.getModifiersEx() & 0x400) == 1024;
    }

    private boolean isButton1Pressed(MouseEvent ev) {
        return ev.getButton() == 1;
    }

    private boolean isCtrlPressed(MouseEvent ev) {
        return (ev.getModifiersEx() & 0x80) == 128;
    }

    JPopupMenu createPopupMenu(int rowIndex) {
        return new TreeNodePopupMenu(this, rowIndex);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.currentCursorPoint != null && this.mousePressCursorPoint != null) {
            this.drawDraggingRectangle(g);
        }
        try {
            this.drawGuideLineToEditor(g);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void drawDraggingRectangle(Graphics g) {
        g.setColor(Color.darkGray);
        g.drawPolyline(new int[]{this.mousePressCursorPoint.x, this.currentCursorPoint.x, this.currentCursorPoint.x, this.mousePressCursorPoint.x, this.mousePressCursorPoint.x}, new int[]{this.mousePressCursorPoint.y, this.mousePressCursorPoint.y, this.currentCursorPoint.y, this.currentCursorPoint.y, this.mousePressCursorPoint.y}, 5);
    }

    private void drawGuideLineToEditor(Graphics g) {
        int editorYOffset = ((JViewport)this.editorPane.getParent()).getViewPosition().y;
        int prevEditorBottom = 0;
        int[] selectedRows = null;
        if (this.getSelectionCount() > 0) {
            selectedRows = (int[])this.getSelectionRows().clone();
            Arrays.sort(selectedRows);
        }
        this.drawGuideLinesToEditor(g, editorYOffset, prevEditorBottom, selectedRows);
    }

    private void drawGuideLinesToEditor(Graphics g, int editorYOffset, int prevEditorBottom, int[] selectedRows) {
        int i = 0;
        while (i < this.getSelectionCount()) {
            int selectedRowTop = selectedRows[i];
            TreePath selectedPath = this.getPathForRow(selectedRowTop);
            int selectedRowBottom = selectedRowTop;
            int j = selectedRowTop + 1;
            while (j < this.getRowCount()) {
                if (!selectedPath.isDescendant(this.getPathForRow(j))) break;
                selectedRowBottom = j++;
            }
            int editorBottom = (Integer)this.editorHeightList.get(i);
            Rectangle selectedRowRectTop = this.getRowBounds(selectedRowTop);
            Rectangle selectedRowRectBottom = this.getRowBounds(selectedRowBottom);
            this.drawGuideLinesToEditor(g, editorYOffset, prevEditorBottom, editorBottom, selectedRowRectTop, selectedRowRectBottom);
            prevEditorBottom = editorBottom;
            ++i;
        }
    }

    private void drawGuideLinesToEditor(Graphics g, int editorYOffset, int prevEditorBottom, int editorBottom, Rectangle selectedRowRectTop, Rectangle selectedRowRectBottom) {
        JViewport viewport = (JViewport)this.getParent();
        g.setColor(GUIDE_COLOR[0]);
        g.drawLine(selectedRowRectTop.x, selectedRowRectTop.y, viewport.getWidth() + viewport.getViewPosition().x, prevEditorBottom - editorYOffset + viewport.getViewPosition().y);
        g.drawLine(selectedRowRectBottom.x, selectedRowRectBottom.y + selectedRowRectBottom.height, viewport.getWidth() + viewport.getViewPosition().x, editorBottom - editorYOffset + viewport.getViewPosition().y);
    }

    public synchronized void setupEditorPane() {
        this.editorPane.removeAll();
        this.editorPane.setLayout(new BoxLayout(this.editorPane, 1));
        int[] rows = this.selectionModel.getSelectionRows();
        if (rows == null) {
            this.setupBackgroundPanel();
            return;
        }
        int paneHeight = this.getEditorExtentHeight();
        this.setCursor(Cursor.getPredefinedCursor(3));
        Arrays.sort(rows);
        int totalHeight = 0;
        AbstractNodeEditor pane = null;
        int i = 0;
        while (i < rows.length) {
            pane = this.createEditorPane(this.getPathForRow(rows[i]));
            if (pane != null) {
                this.editorPane.add(pane);
                totalHeight += pane.getPreferredHeight();
            }
            ++i;
        }
        if (totalHeight < paneHeight) {
            this.updatePreferredSize(rows, paneHeight, totalHeight, pane);
        } else {
            this.editorPane.setPreferredSize(new Dimension(200, totalHeight));
            JViewport viewport = (JViewport)this.editorPane.getParent();
            if (this.mousePressCursorPoint == null || this.currentCursorPoint == null) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.updateViewPosition(totalHeight, viewport);
        }
        this.editorPane.updateUI();
        this.updateEditorHeightList();
        this.repaint();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private int getEditorExtentHeight() {
        return this.mediator.getCurrentEditorScrollPane().getViewport().getExtentSize().height;
    }

    private void updatePreferredSize(int[] rows, int paneHeight, int totalHeight, AbstractNodeEditor pane) {
        if (rows.length == 1 && pane != null) {
            this.addEditorPane(paneHeight, totalHeight, pane);
            pane.setPreferredSize(new Dimension(200, paneHeight));
        } else {
            this.editorPane.setPreferredSize(new Dimension(200, paneHeight));
            int i = 0;
            while (i < this.editorPane.getComponentCount()) {
                ((JComponent)this.editorPane.getComponent(i)).setPreferredSize(new Dimension(200, paneHeight / this.editorPane.getComponentCount()));
                ++i;
            }
        }
    }

    private void updateViewPosition(int totalHeight, JViewport viewport) {
        if (this.mousePressCursorPoint.y < this.currentCursorPoint.y) {
            this.editorPane.updateUI();
            Point viewPosition = viewport.getViewPosition();
            viewport.setViewPosition(new Point(0, totalHeight - viewport.getExtentSize().height));
        } else {
            viewport.setViewPosition(new Point(0, 0));
        }
    }

    private void updateEditorHeightList() {
        this.editorHeightList.clear();
        int t = 0;
        int i = 0;
        while (i < this.editorPane.getComponentCount()) {
            int h = (int)this.editorPane.getComponent(i).getPreferredSize().getHeight();
            this.editorHeightList.add(new Integer(t += h));
            ++i;
        }
    }

    private void addEditorPane(int paneHeight, int totalHeight, AbstractNodeEditor pane) {
        String localName = pane.getNode().getLocalName();
        if (pane instanceof ContainerEditor) {
            this.editorPane.add(Box.createVerticalStrut(paneHeight - totalHeight));
            pane.setSize(new Dimension(200, paneHeight));
        }
        this.editorPane.setPreferredSize(new Dimension(200, paneHeight));
    }

    private void setupBackgroundPanel() {
        this.editorPane.setSize(new Dimension(200, 0));
        this.editorPane.setPreferredSize(new Dimension(200, 0));
        this.editorPane.setLayout(new BorderLayout());
        JPanel panel = this.mediator.getBackgroundPanel();
        this.editorPane.add((Component)panel, "South");
        this.editorPane.updateUI();
    }

    public AbstractNodeEditor createEditorPane(TreePath path) {
        if (path == null) {
            return null;
        }
        return this.editorResourceFactory.create(this.mediator, this.source, (Node)path.getLastPathComponent());
    }

    public JComponent getEditorPane() {
        return this.editorPane;
    }
}

