/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.httpd;

import java.util.List;
import net.sf.sqs_xml.httpd.MicroHttpd;
import net.sf.sqs_xml.httpd.URLFilter;
import net.sf.sqs_xml.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class FormFilter
extends XMLFilterImpl {
    URLFilter filter;
    String tabindex;
    String action;
    String srcfile;
    List matrix;
    String name;
    int rowIndex = -1;

    public FormFilter(MicroHttpd httpd, String basePath, String action, String srcfile, List matrix) {
        this.filter = new URLFilter(httpd, basePath);
        this.action = action;
        this.srcfile = srcfile;
        this.matrix = matrix;
    }

    public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        if (localName.equals("img")) {
            this.name = attributes.getValue("alt");
            this.filter.handleImage(attributes, attributesImpl);
        } else if (localName.equals("a")) {
            this.tabindex = attributes.getValue("tabindex");
            this.filter.handleAnchor(attributes, attributesImpl);
        } else if (localName.equals("table")) {
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("http://www.w3.org/1999/xhtml", "method", "method", "CDATA", "POST");
            attr.addAttribute("http://www.w3.org/1999/xhtml", "action", "action", "CDATA", this.action);
            super.startElement("http://www.w3.org/1999/xhtml", "form", "form", attr);
        }
        super.startElement(namespaceUri, localName, qualifiedName, attributesImpl);
    }

    public void endElement(String namespaceUri, String localName, String qualifiedName) throws SAXException {
        super.endElement(namespaceUri, localName, qualifiedName);
        if (localName.equals("tr")) {
            ++this.rowIndex;
        } else if (localName.equals("a") && this.name != null) {
            this.handleTextarea(this.name, this.rowIndex);
            this.name = null;
        } else if (localName.equals("table")) {
            this.handleHidden(this.filter.basePath, this.srcfile);
            this.handleSubmit();
            super.endElement("http://www.w3.org/1999/xhtml", "form", "form");
        }
    }

    private void handleTextarea(String name, int rowIndex) throws SAXException {
        super.startElement("http://www.w3.org/1999/xhtml", "p", "p", new AttributesImpl());
        int colIndex = Integer.parseInt(this.tabindex) + 2;
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("http://www.w3.org/1999/xhtml", "name", "name", "CDATA", String.valueOf(colIndex) + "-" + rowIndex);
        attr.addAttribute("http://www.w3.org/1999/xhtml", "cols", "cols", "CDATA", "45");
        attr.addAttribute("http://www.w3.org/1999/xhtml", "rows", "rows", "CDATA", "3");
        attr.addAttribute("http://www.w3.org/1999/xhtml", "tabindex", "tabindex", "CDATA", this.tabindex);
        super.startElement("http://www.w3.org/1999/xhtml", "textarea", "textarea", attr);
        List list = (List)this.matrix.get(rowIndex);
        String value = (String)list.get(colIndex);
        char[] chars = StringUtil.escapeHTML(value).toCharArray();
        super.characters(chars, 0, chars.length);
        super.endElement("http://www.w3.org/1999/xhtml", "textarea", "textarea");
        super.endElement("http://www.w3.org/1999/xhtml", "p", "p");
    }

    private void handleSubmit() throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("http://www.w3.org/1999/xhtml", "type", "type", "CDATA", "submit");
        attr.addAttribute("http://www.w3.org/1999/xhtml", "tabindex", "tabindex", "CDATA", "32767");
        attr.addAttribute("http://www.w3.org/1999/xhtml", "value", "value", "CDATA", "     \u66f4\u65b0     ");
        super.startElement("http://www.w3.org/1999/xhtml", "input", "input", attr);
        super.endElement("http://www.w3.org/1999/xhtml", "input", "input");
    }

    private void handleHidden(String dir, String src) throws SAXException {
        this.createHiddenInput("dir", dir);
        this.createHiddenInput("src", src);
    }

    private void createHiddenInput(String name, String value) throws SAXException {
        AttributesImpl attr = null;
        attr = new AttributesImpl();
        attr.addAttribute("http://www.w3.org/1999/xhtml", "type", "type", "CDATA", "hidden");
        attr.addAttribute("http://www.w3.org/1999/xhtml", "name", "name", "CDATA", name);
        attr.addAttribute("http://www.w3.org/1999/xhtml", "value", "value", "CDATA", value);
        super.startElement("http://www.w3.org/1999/xhtml", "input", "input", attr);
        super.endElement("http://www.w3.org/1999/xhtml", "input", "input");
    }
}

