/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public final class IntStack {
    private int fDepth;
    private int[] fData;

    public final int size() {
        return this.fDepth;
    }

    public final void push(int n) {
        this.ensureCapacity(this.fDepth + 1);
        this.fData[this.fDepth++] = n;
    }

    public final int peek() {
        return this.fData[this.fDepth - 1];
    }

    public final int pop() {
        return this.fData[--this.fDepth];
    }

    public final void clear() {
        this.fDepth = 0;
    }

    public final void print() {
        System.out.print('(');
        System.out.print(this.fDepth);
        System.out.print(") {");
        int n = 0;
        while (n < this.fDepth) {
            if (n == 3) {
                System.out.print(" ...");
                break;
            }
            System.out.print(' ');
            System.out.print(this.fData[n]);
            if (n < this.fDepth - 1) {
                System.out.print(',');
            }
            ++n;
        }
        System.out.print(" }");
        System.out.println();
    }

    private final boolean ensureCapacity(int n) {
        try {
            return this.fData[n] != 0;
        }
        catch (NullPointerException nullPointerException) {
            this.fData = new int[32];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[] nArray = new int[this.fData.length * 2];
            System.arraycopy(this.fData, 0, nArray, 0, this.fData.length);
            this.fData = nArray;
        }
        return true;
    }
}

