/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.xml.XMLCharacters;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtilities
extends XMLUtilities {
    protected DOMUtilities() {
    }

    public static void writeDocument(Document doc, Writer w) throws IOException {
        Node n = doc.getFirstChild();
        while (n != null) {
            DOMUtilities.writeNode(n, w);
            n = n.getNextSibling();
        }
    }

    public static void writeNode(Node n, Writer w) throws IOException {
        switch (n.getNodeType()) {
            case 1: {
                Node c;
                w.write("<");
                w.write(n.getNodeName());
                if (n.hasAttributes()) {
                    NamedNodeMap attr = n.getAttributes();
                    int len = attr.getLength();
                    int i = 0;
                    while (i < len) {
                        Attr a = (Attr)attr.item(i);
                        w.write(" ");
                        w.write(a.getNodeName());
                        w.write("=\"");
                        w.write(DOMUtilities.contentToString(a.getNodeValue()));
                        w.write("\"");
                        ++i;
                    }
                }
                if ((c = n.getFirstChild()) != null) {
                    w.write(">");
                    while (c != null) {
                        DOMUtilities.writeNode(c, w);
                        c = c.getNextSibling();
                    }
                    w.write("</");
                    w.write(n.getNodeName());
                    w.write(">");
                    break;
                }
                w.write("/>");
                break;
            }
            case 3: {
                w.write(DOMUtilities.contentToString(n.getNodeValue()));
                break;
            }
            case 4: {
                w.write("<![CDATA[");
                w.write(n.getNodeValue());
                w.write("]]>");
                break;
            }
            case 5: {
                w.write("&");
                w.write(n.getNodeName());
                w.write(";");
                break;
            }
            case 7: {
                w.write("<?");
                w.write(n.getNodeName());
                w.write(n.getNodeValue());
                w.write("?>");
                break;
            }
            case 8: {
                w.write("<!--");
                w.write(n.getNodeValue());
                w.write("-->");
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new Error("Internal error (" + n.getNodeType() + ")");
            }
        }
    }

    public static String contentToString(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '\'': {
                    result.append("&apos;");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static Document deepCloneDocument(Document doc, DOMImplementation impl) {
        Element root = doc.getDocumentElement();
        Document result = impl.createDocument(root.getNamespaceURI(), root.getNodeName(), null);
        Element rroot = result.getDocumentElement();
        boolean before = true;
        Node n = doc.getFirstChild();
        while (n != null) {
            if (n == root) {
                before = false;
                if (root.hasAttributes()) {
                    NamedNodeMap attr = root.getAttributes();
                    int len = attr.getLength();
                    int i = 0;
                    while (i < len) {
                        rroot.setAttributeNode((Attr)result.importNode(attr.item(i), true));
                        ++i;
                    }
                }
                Node c = root.getFirstChild();
                while (c != null) {
                    rroot.appendChild(result.importNode(c, true));
                    c = c.getNextSibling();
                }
            } else if (n.getNodeType() != 10) {
                if (before) {
                    result.insertBefore(result.importNode(n, true), rroot);
                } else {
                    result.appendChild(result.importNode(n, true));
                }
            }
            n = n.getNextSibling();
        }
        return result;
    }

    public static boolean isValidName(String s) {
        int m;
        char c = s.charAt(0);
        int d = c / 32;
        if ((XMLCharacters.NAME_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
            return false;
        }
        int len = s.length();
        int i = 1;
        while (i < len) {
            c = s.charAt(i);
            d = c / 32;
            if ((XMLCharacters.NAME_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidPrefix(String s) {
        return s.indexOf(58) == -1;
    }

    public static String getPrefix(String s) {
        int i = s.indexOf(58);
        return i == -1 || i == s.length() - 1 ? null : s.substring(0, i);
    }

    public static String getLocalName(String s) {
        int i = s.indexOf(58);
        return i == -1 || i == s.length() - 1 ? s : s.substring(i + 1);
    }

    /*
     * Unable to fully structure code
     */
    public static void parseStyleSheetPIData(String data, HashTable table) {
        i = 0;
        while (i < data.length()) {
            c = data.charAt(i);
            if (!XMLUtilities.isXMLSpace(c)) break;
            ++i;
        }
        block1: while (i < data.length()) {
            c = data.charAt(i);
            d = c / 32;
            if ((XMLCharacters.NAME_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c);
            }
            ident = new StringBuffer();
            ident.append(c);
            while (++i < data.length()) {
                c = data.charAt(i);
                d = c / 32;
                if ((XMLCharacters.NAME_CHARACTER[d] & 1 << (m = c % 32)) == 0) break;
                ident.append(c);
            }
            if (i < data.length()) ** GOTO lbl26
            throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            while (XMLUtilities.isXMLSpace(c = data.charAt(i))) {
                ++i;
lbl26:
                // 2 sources

                if (i < data.length()) continue;
            }
            if (i >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            if (data.charAt(i) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            ++i;
            while (i < data.length()) {
                c = data.charAt(i);
                if (!XMLUtilities.isXMLSpace(c)) break;
                ++i;
            }
            if (i >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            c = data.charAt(i);
            ++i;
            value = new StringBuffer();
            if (c == '\'') {
                while (i < data.length()) {
                    c = data.charAt(i);
                    if (c == '\'') break;
                    value.append(c);
                    ++i;
                }
                if (i >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else if (c == '\"') {
                while (i < data.length()) {
                    c = data.charAt(i);
                    if (c == '\"') break;
                    value.append(c);
                    ++i;
                }
                if (i >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            table.put(ident.toString().intern(), value.toString());
            ++i;
            while (i < data.length()) {
                c = data.charAt(i);
                if (!XMLUtilities.isXMLSpace(c)) continue block1;
                ++i;
            }
        }
    }
}

