/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;

public class PdfPCell
extends Rectangle {
    private int horizontalAlignment = 0;
    private int verticalAlignment = 4;
    private float paddingLeft = 2.0f;
    private float paddingRight = 2.0f;
    private float paddingTop = 2.0f;
    private float paddingBottom = 2.0f;
    protected float fixedLeading = 0.0f;
    protected float multipliedLeading = 1.0f;
    protected float extraParagraphSpace = 0.0f;
    protected float indent = 0.0f;
    protected float followingIndent = 0.0f;
    protected float rightIndent = 0.0f;
    protected Phrase phrase;
    private float fixedHeight = 0.0f;
    private boolean noWrap = false;
    private PdfPTable table;
    private float minimumHeight;
    private int colspan = 1;
    private float spaceCharRatio = 0.0f;
    protected int runDirection = 0;
    private Image image;
    private PdfPCellEvent cellEvent;
    private int arabicOptions = 0;
    private boolean useDescender;

    public PdfPCell(Phrase phrase) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.phrase = phrase;
    }

    public PdfPCell(Image image) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.phrase = new Phrase(new Chunk(image, 0.0f, 0.0f));
        this.fixedLeading = 0.0f;
        this.multipliedLeading = 1.0f;
        this.setPadding(0.0f);
    }

    public PdfPCell(Image image, boolean fit) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        if (fit) {
            this.borderWidth = 0.5f;
            this.border = 15;
            this.image = image;
            this.fixedLeading = 0.0f;
            this.multipliedLeading = 1.0f;
            this.setPadding(this.borderWidth / 2.0f);
        } else {
            this.borderWidth = 0.5f;
            this.border = 15;
            this.phrase = new Phrase(new Chunk(image, 0.0f, 0.0f));
            this.fixedLeading = 0.0f;
            this.multipliedLeading = 1.0f;
            this.setPadding(0.0f);
        }
    }

    public PdfPCell(PdfPTable table) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.fixedLeading = 0.0f;
        this.multipliedLeading = 1.0f;
        this.setPadding(0.0f);
        this.table = table;
    }

    public PdfPCell(PdfPCell cell) {
        super(cell.llx, cell.lly, cell.urx, cell.ury);
        this.border = cell.border;
        this.borderWidth = cell.borderWidth;
        this.color = cell.color;
        this.background = cell.background;
        this.grayFill = cell.grayFill;
        this.horizontalAlignment = cell.horizontalAlignment;
        this.verticalAlignment = cell.verticalAlignment;
        this.paddingLeft = cell.paddingLeft;
        this.paddingRight = cell.paddingRight;
        this.paddingTop = cell.paddingTop;
        this.paddingBottom = cell.paddingBottom;
        this.fixedLeading = cell.fixedLeading;
        this.multipliedLeading = cell.multipliedLeading;
        this.extraParagraphSpace = cell.extraParagraphSpace;
        this.indent = cell.indent;
        this.followingIndent = cell.followingIndent;
        this.rightIndent = cell.rightIndent;
        this.phrase = cell.phrase;
        this.fixedHeight = cell.fixedHeight;
        this.minimumHeight = cell.minimumHeight;
        this.noWrap = cell.noWrap;
        this.colspan = cell.colspan;
        this.spaceCharRatio = cell.spaceCharRatio;
        this.runDirection = cell.runDirection;
        if (cell.table != null) {
            this.table = new PdfPTable(cell.table);
        }
        this.image = Image.getInstance(cell.image);
        this.cellEvent = cell.cellEvent;
        this.arabicOptions = cell.arabicOptions;
        this.useDescender = cell.useDescender;
    }

    public Phrase getPhrase() {
        return this.phrase;
    }

    public void setPhrase(Phrase phrase) {
        this.phrase = phrase;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(float paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(float paddingRight) {
        this.paddingRight = paddingRight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(float paddingTop) {
        this.paddingTop = paddingTop;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(float paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public void setPadding(float padding) {
        this.paddingBottom = padding;
        this.paddingTop = padding;
        this.paddingLeft = padding;
        this.paddingRight = padding;
    }

    public void setLeading(float fixedLeading, float multipliedLeading) {
        this.fixedLeading = fixedLeading;
        this.multipliedLeading = multipliedLeading;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setIndent(float indent) {
        this.indent = indent;
    }

    public float getIndent() {
        return this.indent;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.extraParagraphSpace = extraParagraphSpace;
    }

    public float getFixedHeight() {
        return this.fixedHeight;
    }

    public void setFixedHeight(float fixedHeight) {
        this.fixedHeight = fixedHeight;
        this.minimumHeight = 0.0f;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean noWrap) {
        this.noWrap = noWrap;
    }

    PdfPTable getTable() {
        return this.table;
    }

    void setTable(PdfPTable table) {
        this.table = table;
    }

    public float getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(float minimumHeight) {
        this.minimumHeight = minimumHeight;
        this.fixedHeight = 0.0f;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public void setFollowingIndent(float indent) {
        this.followingIndent = indent;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float indent) {
        this.rightIndent = indent;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float spaceCharRatio) {
        this.spaceCharRatio = spaceCharRatio;
    }

    public void setRunDirection(int runDirection) {
        if (runDirection < 0 || runDirection > 3) {
            throw new RuntimeException("Invalid run direction: " + runDirection);
        }
        this.runDirection = runDirection;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public PdfPCellEvent getCellEvent() {
        return this.cellEvent;
    }

    public void setCellEvent(PdfPCellEvent cellEvent) {
        this.cellEvent = cellEvent;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int arabicOptions) {
        this.arabicOptions = arabicOptions;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public void setUseDescender(boolean useDescender) {
        this.useDescender = useDescender;
    }
}

