/*

 SelectFormItemList.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/01

 */
package net.sf.sqs_xml.editor.sqs.modules.panel;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.EditorUtil;
import net.sf.sqs_xml.editor.base.modules.UpdateListener;
import net.sf.sqs_xml.editor.base.modules.UpdateTarget;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractNodeEditorPanel;
import net.sf.sqs_xml.xmlns.SQSNamespaces;

import org.w3c.dom.Element;



/**
 * @author hiroya
 *
 */
public class SelectFormItemListPanel extends AbstractNodeEditorPanel implements UpdateTarget{
    SelectFormItemListModel model;
    Item[] itemList = null;
    Icon itemIcon;
    Box itemListFormInnerPane;
    SelectFormItemListPanel self;
    public SelectFormItemListPanel(AbstractNodeEditor editor){
        super(editor);
        self = this;
        this.model = new SelectFormItemListModel(editor.getMediator(), editor.getSource(), (Element)editor.getNode());
        this.itemIcon = editor.getMediator().getCurrentTreePane().getIcon("item", SQSNamespaces.XFORMS_URI);
        this.itemListFormInnerPane = Box.createVerticalBox();
        JPanel itemListForm = new JPanel();
        itemListForm.setBorder(new TitledBorder(EditorUtil.LOWERED_BORDER, "選択肢"));
        itemListForm.setBackground(editor.getResource().bgcolor);
        itemListForm.setLayout(new BorderLayout());
        itemListForm.add(createItemListScrollPanel(), BorderLayout.CENTER);
        setBackground(editor.getResource().bgcolor);
        add(itemListForm);
        initialize();
        initSize();
    }
    
    public int getPreferredHeight(){
        return 40;
    }
    
    /**
     * @param model
     * @return
     */
    private JScrollPane createItemListScrollPanel() {
        final JScrollPane itemListFormScrollPane = new JScrollPane(itemListFormInnerPane);
        itemListFormScrollPane.setWheelScrollingEnabled(true);
        itemListFormScrollPane.addComponentListener(new ComponentAdapter(){
            public void componentResized(ComponentEvent ev) {
                if(itemListFormScrollPane != null && model != null){
                    int increment = (int)(itemListFormInnerPane.getHeight()/model.size());
                    itemListFormScrollPane.getVerticalScrollBar().setUnitIncrement(increment);
                }
            }
        });
        return itemListFormScrollPane;
    }

    public synchronized void initialize(){
        itemListFormInnerPane.removeAll();
        itemList = new Item[model.size()];
        for(int i=0; i < model.size(); i++){
            Item item = createItem(i);
            itemList[i] = item;
            itemListFormInnerPane.add(item);
        }
    }
    
    public Item createItem(int i){
        return new Item(this, i);
    }
    
    public synchronized Item get(int index){
        return itemList[index];
    }
    
    public boolean updateNodeValue(){
        boolean isUpdated = false;
        for(int i=0; i < itemList.length; i++){
            if(itemList[i].updateNodeValue()){
                isUpdated = true;
            }else{
            }
        }
        if(isUpdated){
            getEditor().updateNodeValue(true);
        }
        return isUpdated;
    }

    public class Item extends JPanel{
        PopupMenu popupMenu;
        int index;
        JTextField valueTextField;
        JTextField labelTextField;
        UpdateListener updateListener;
        JComponent itemFormWest;

        Item(AbstractNodeEditorPanel itemListForm, int index){
            this.index = index;
            updateListener = new UpdateListener(self);
            popupMenu = new PopupMenu(index);
            setLayout(new BorderLayout());
            setBackground(getEditor().getResource().bgcolor);

            itemFormWest = createFormItemWest();
            add(itemFormWest, BorderLayout.WEST);
        
            labelTextField = createFormItemCenter();
            add(labelTextField, BorderLayout.CENTER);

            /*
            labelTextField.setTransferHandler(new TransferHandler("text"));
            labelTextField.addMouseListener(new MouseAdapter() {
                public void mousePressed(MouseEvent e) {
                    JComponent c = (JComponent)e.getSource();
                    TransferHandler th = c.getTransferHandler();
                    th.exportAsDrag(c, e, TransferHandler.COPY);
                }
            });
            */

            setPreferredSize(new Dimension(340, 20));
            setSize(new Dimension(340, 20));
            addMouseListener(popupMenu.getMouseListener());
        }
                
        public void setSelectedBackGroundColor(boolean isSelected){
            if(isSelected){
                setBackground(getEditor().getResource().bgcolor.brighter());
            }else{
                setBackground(getEditor().getResource().bgcolor);
            }
        }

        JTextField getLabelTextField(){
            return labelTextField;
        }

        public boolean updateNodeValue(){
            return model.updateNodeValue(index,
                      	labelTextField.getText(),
                      	valueTextField.getText());
        }

        private JComponent createFormItemWest() {
            valueTextField = new JTextField();
            valueTextField.setSize(2,1);
            valueTextField.setText(model.getValue(index));
            valueTextField.setBackground(getBackground());
            valueTextField.setEditable(true);
            valueTextField.addFocusListener(updateListener);
            valueTextField.setPreferredSize(new Dimension(16, 14));
            JComponent itemFormWest = Box.createHorizontalBox();
            itemFormWest.add(new JLabel(itemIcon));
            itemFormWest.add(valueTextField);
            itemFormWest.add(new JLabel(":"));
            if(getEditor().getSource().isReadOnly()){
                valueTextField.setEnabled(false);
            }        
            return itemFormWest;
        }

        private JTextField createFormItemCenter() {
            labelTextField = new JTextField();
            labelTextField.setSize(10,1);
            labelTextField.setText(model.getLabel(index));
            labelTextField.addFocusListener(updateListener);
            if(getEditor().getSource().isReadOnly()){
                labelTextField.setEnabled(false);
            }        
            return labelTextField;
        }


        class PopupMenu extends JPopupMenu{
            private PopupAdapter listener;
            private JMenuItem deleteButton;
            private MouseAdapter mouseAdapter = new MouseAdapter(){
                public void mouseEntered(MouseEvent e) {
                    setSelectedBackGroundColor(true);
                }
                public void mouseExited(MouseEvent e) {
                    setSelectedBackGroundColor(false);
                }
            };
            
            PopupMenu(int index){
                setPopupSize(300,70);
                addMouseListener(mouseAdapter);
                listener = new PopupAdapter(this);
                
                JMenuItem insertBeforeButton = createPopupMenuItem("この選択肢の「前」に新しい選択肢を挿入", "b "+index);
                JMenuItem insertAfterButton = createPopupMenuItem("この選択肢の「後」に新しい選択肢を挿入", "a "+index);
                deleteButton = createPopupMenuItem("この選択肢を削除", "d "+index);
                
                add(insertBeforeButton);
                add(insertAfterButton);
                addSeparator();
                add(deleteButton);
            }
            
            private JMenuItem createPopupMenuItem(String label, String command){
                JMenuItem item = new JMenuItem(label);
                item.setActionCommand(command);
                item.addActionListener(listener);
                item.addMouseListener(mouseAdapter);
                return item;
            }
            
            MouseAdapter getMouseListener(){
                return listener;
            }
            
            public JMenuItem getDeleteButton(){
                return deleteButton;
            }
            
            class PopupAdapter extends MouseAdapter implements ActionListener{
                private JPopupMenu popupMenu;
                PopupAdapter(JPopupMenu commandPopup){
                    this.popupMenu = commandPopup;            
                }
                public void actionPerformed(ActionEvent ev){
                    String[] commandArgs = ev.getActionCommand().split("\\s");
                    String command = commandArgs[0];
                    int target = Integer.parseInt(commandArgs[1]);
                    if(command.equals("d")){
                        delete(target);
                    }else if(command.equals("b")){
                        insertBefore(target);
                    }else if(command.equals("a")){
                        insertAfter(target);
                    }else{
                        return;
                    }
                    setSelectedBackGroundColor(false);
                    initialize();
                    if(command.equals("b")){
                        get(target).getLabelTextField().requestFocus();
                    }else if(command.equals("a")){
                        get(target+1).getLabelTextField().requestFocus();
                    }
                    getEditor().updateNodeValue(true);
                    getEditor().updateUI();
                    getEditor().getMediator().getCurrentTreePane().updateUI();
                }

                private void insertAfter(int target) {
                    if(target == model.size() - 1){
                        model.add("", "", 1);        
                    }else{
                        model.insert(target+1, "","", 1);
                    }
                    getDeleteButton().setEnabled(true);
                }

                private void insertBefore(int target) {
                    model.insert(target, "","", 1);
                    getDeleteButton().setEnabled(true);
                }

                private void delete(int target) {
                    if(1 < model.size()){
                        model.remove(target);
                        if(model.size() == 1){
                            getDeleteButton().setEnabled(false);
                        }
                    }
                }
                public void mousePressed(MouseEvent e){
                    //if (e.isPopupTrigger()) {
                    setSelectedBackGroundColor(true);
            	    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    //}
                }

                public void mouseReleased(MouseEvent e){
                }
                
                public void mouseEntered(MouseEvent e){  
                    setSelectedBackGroundColor(true);
                }
                public void mouseExited(MouseEvent e){
                    if (! popupMenu.isVisible()) {
                        setSelectedBackGroundColor(false);
                    }
                }
            }
        }
     }
}
