/*

 ReadingLogic.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on Jul 18, 2004

 */
package net.sf.sqs_xml.reader.logic;
import java.io.File;
import net.sf.sqs_xml.swing.LoggerConsoleFrame;
import net.sf.sqs_xml.translator.logic.AbstractTranslator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;

/**
 * @author hiroya
 *
 */
public class MarkReaderTranslator extends AbstractTranslator{
    ReaderRunningState engineState = null;
    LoggerConsoleFrame logger = null;
    
    public MarkReaderTranslator() throws TranslatorException {
        super();
    }
    
    public LoggerConsoleFrame getLogger(){
        return logger;
    }
    
    public void initializeEnvironment(){
    }
    
    public void translate(final File imagedir, final TranslatorResource resource, final File userSelectedTgtDir) throws TranslatorException {
        logger = (LoggerConsoleFrame)resource.getLogger();
        initializeEnvironment();
        this.engineState = new ReaderRunningState(new ReaderIndexMapper());
        new Thread(){
            public void run(){
                engineState.start();
                //List srcFileList = FileUtil.find(imagedir, "-csv.txt");
                //File srcfile = null, 
                //if(srcFileList.size() == 1){
                //    srcfile = (File)srcFileList.get(0);
                //}
                try{
                    new ReaderResultTask(new BaseTaskSource(imagedir, userSelectedTgtDir), 
                            new BaseTaskTarget(engineState), new ReaderProcessView(logger)).run();
                    engineState.finished();
                    engineState.notifyTaskStopped();
                    return;
                } catch (ThreadSuspendingException ignore) {
                } catch (Exception e){
                    e.printStackTrace();
                }
                engineState.aborted();
                engineState.notifyTaskStopped();                
            }
        }.start();

        engineState.waitTaskStopped();
    }
    
    public void setSuspending(){
        engineState.suspending();
    }

}
