/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.SVGFontFace;
import org.apache.batik.bridge.SVGUtilities;
import org.w3c.dom.Element;

public class SVGFontFaceElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public String getLocalName() {
        return "font-face";
    }

    public SVGFontFace createFontFace(BridgeContext ctx, Element fontFaceElement) {
        float overlineThickness;
        float overlinePos;
        float strikethroughThickness;
        float strikethroughPos;
        float underlineThickness;
        float underlinePos;
        float descent;
        float ascent;
        String ascentStr;
        float slope;
        String slopeStr;
        String fontStretch;
        String fontVariant;
        String fontStyle;
        float unitsPerEm;
        String familyNames = fontFaceElement.getAttributeNS(null, "font-family");
        String unitsPerEmStr = fontFaceElement.getAttributeNS(null, "units-per-em");
        if (unitsPerEmStr.length() == 0) {
            unitsPerEmStr = "1000";
        }
        try {
            unitsPerEm = SVGUtilities.convertSVGNumber(unitsPerEmStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"units-per-em", unitsPerEmStr});
        }
        String fontWeight = fontFaceElement.getAttributeNS(null, "font-weight");
        if (fontWeight.length() == 0) {
            fontWeight = "all";
        }
        if ((fontStyle = fontFaceElement.getAttributeNS(null, "font-style")).length() == 0) {
            fontStyle = "all";
        }
        if ((fontVariant = fontFaceElement.getAttributeNS(null, "font-variant")).length() == 0) {
            fontVariant = "normal";
        }
        if ((fontStretch = fontFaceElement.getAttributeNS(null, "font-stretch")).length() == 0) {
            fontStretch = "normal";
        }
        if ((slopeStr = fontFaceElement.getAttributeNS(null, "slope")).length() == 0) {
            slopeStr = "0";
        }
        try {
            slope = SVGUtilities.convertSVGNumber(slopeStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"0", slopeStr});
        }
        String panose1 = fontFaceElement.getAttributeNS(null, "panose-1");
        if (panose1.length() == 0) {
            panose1 = "0 0 0 0 0 0 0 0 0 0";
        }
        if ((ascentStr = fontFaceElement.getAttributeNS(null, "ascent")).length() == 0) {
            ascentStr = String.valueOf(unitsPerEm / 2.0f);
        }
        try {
            ascent = SVGUtilities.convertSVGNumber(ascentStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"0", ascentStr});
        }
        String descentStr = fontFaceElement.getAttributeNS(null, "descent");
        if (descentStr.length() == 0) {
            descentStr = String.valueOf(unitsPerEm / 2.0f);
        }
        try {
            descent = SVGUtilities.convertSVGNumber(descentStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"0", descentStr});
        }
        String underlinePosStr = fontFaceElement.getAttributeNS(null, "underline-position");
        if (underlinePosStr.length() == 0) {
            underlinePosStr = "0";
        }
        try {
            underlinePos = SVGUtilities.convertSVGNumber(underlinePosStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"0", underlinePosStr});
        }
        String underlineThicknessStr = fontFaceElement.getAttributeNS(null, "underline-thickness");
        if (underlineThicknessStr.length() == 0) {
            underlineThicknessStr = String.valueOf(unitsPerEm / 20.0f);
        }
        try {
            underlineThickness = SVGUtilities.convertSVGNumber(underlineThicknessStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"0", underlineThicknessStr});
        }
        String strikethroughPosStr = fontFaceElement.getAttributeNS(null, "strikethrough-position");
        if (strikethroughPosStr.length() == 0) {
            strikethroughPosStr = String.valueOf(ascent / 3.0f);
        }
        try {
            strikethroughPos = SVGUtilities.convertSVGNumber(strikethroughPosStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"0", strikethroughPosStr});
        }
        String strikethroughThicknessStr = fontFaceElement.getAttributeNS(null, "strikethrough-thickness");
        if (strikethroughThicknessStr.length() == 0) {
            strikethroughThicknessStr = String.valueOf(unitsPerEm / 20.0f);
        }
        try {
            strikethroughThickness = SVGUtilities.convertSVGNumber(strikethroughThicknessStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"0", strikethroughThicknessStr});
        }
        String overlinePosStr = fontFaceElement.getAttributeNS(null, "overline-position");
        if (overlinePosStr.length() == 0) {
            overlinePosStr = String.valueOf(ascent);
        }
        try {
            overlinePos = SVGUtilities.convertSVGNumber(overlinePosStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"0", overlinePosStr});
        }
        String overlineThicknessStr = fontFaceElement.getAttributeNS(null, "overline-thickness");
        if (overlineThicknessStr.length() == 0) {
            overlineThicknessStr = String.valueOf(unitsPerEm / 20.0f);
        }
        try {
            overlineThickness = SVGUtilities.convertSVGNumber(overlineThicknessStr);
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(fontFaceElement, "attribute.malformed", new Object[]{"0", overlineThicknessStr});
        }
        return new SVGFontFace(familyNames, unitsPerEm, fontWeight, fontStyle, fontVariant, fontStretch, slope, panose1, ascent, descent, strikethroughPos, strikethroughThickness, underlinePos, underlineThickness, overlinePos, overlineThickness);
    }
}

