/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.util.LazyList;

public class RequestListenerFilter
implements Filter {
    private ServletContext _servletContext;
    private Object _requestListeners;
    private Object _requestAttributeListeners;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._servletContext = filterConfig.getServletContext();
    }

    protected void setRequestAttributeListeners(Object list) {
        this._requestAttributeListeners = list;
    }

    protected void setRequestListeners(Object list) {
        this._requestListeners = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        boolean notified = false;
        if (this._requestListeners != null) {
            if (request instanceof Dispatcher.DispatcherRequest) {
                if (((Dispatcher.DispatcherRequest)((Object)request)).crossContext()) {
                    this.requestInitialized((ServletRequest)request);
                    notified = true;
                }
            } else {
                this.requestInitialized((ServletRequest)request);
                notified = true;
            }
        }
        if (this._requestAttributeListeners != null) {
            if (request instanceof Dispatcher.DispatcherRequest) {
                if (((Dispatcher.DispatcherRequest)((Object)request)).crossContext()) {
                    request = new NotifyRequest(srequest);
                }
            } else {
                request = new NotifyRequest(srequest);
            }
        }
        try {
            chain.doFilter(request, response);
            Object var7_6 = null;
            if (notified) {
                this.requestDestroyed((ServletRequest)request);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (notified) {
                this.requestDestroyed((ServletRequest)request);
            }
            throw throwable;
        }
    }

    public void destroy() {
    }

    private void requestInitialized(ServletRequest request) {
        ServletRequestEvent event = new ServletRequestEvent(this._servletContext, request);
        int i = 0;
        while (i < LazyList.size(this._requestListeners)) {
            ((ServletRequestListener)LazyList.get(this._requestListeners, i)).requestInitialized(event);
            ++i;
        }
    }

    private void requestDestroyed(ServletRequest request) {
        ServletRequestEvent event = new ServletRequestEvent(this._servletContext, request);
        int i = LazyList.size(this._requestListeners);
        while (i-- > 0) {
            ((ServletRequestListener)LazyList.get(this._requestListeners, i)).requestDestroyed(event);
        }
    }

    private void attributeNotify(ServletRequest request, String name, Object oldValue, Object newValue) {
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this._servletContext, request, name, newValue == null ? oldValue : newValue);
        int i = 0;
        while (i < LazyList.size(this._requestAttributeListeners)) {
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)LazyList.get(this._requestAttributeListeners, i);
            if (oldValue == null) {
                listener.attributeAdded(event);
            } else if (newValue == null) {
                listener.attributeRemoved(event);
            } else {
                listener.attributeReplaced(event);
            }
            ++i;
        }
    }

    private class NotifyRequest
    extends HttpServletRequestWrapper {
        NotifyRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        public void setAttribute(String name, Object value) {
            Object old = this.getAttribute(name);
            super.setAttribute(name, value);
            RequestListenerFilter.this.attributeNotify((ServletRequest)this, name, old, value);
        }

        public void removeAttribute(String name) {
            Object old = this.getAttribute(name);
            super.removeAttribute(name);
            RequestListenerFilter.this.attributeNotify((ServletRequest)this, name, old, null);
        }
    }
}

