/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.io.File;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.sf.sqs_xml.editor.base.source.SourceManager;
import net.sf.sqs_xml.editor.base.swing.EditorResourceFactory;
import net.sf.sqs_xml.editor.base.swing.NodeTreePane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorFrame;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMenuBarMediator;
import net.sf.sqs_xml.editor.base.swing.SourceEditorTabbedPane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorToolBar;

public abstract class SourceEditorMediator {
    JFrame frame = null;
    SourceEditorTabbedPane tabbedPane;
    SourceEditorMenuBarMediator menuBarMediator;
    SourceEditorToolBar toolBar;
    SourceManager sourceManager;
    EditorResourceFactory resourceFactory = null;

    public SourceEditorMediator() throws ClassCastException, IllegalAccessException, InstantiationException, ClassNotFoundException, UnsupportedLookAndFeelException {
        System.setProperty("swing.plaf.metal.controlFont", "Monospaced-12");
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        this.sourceManager = this.createSourceManager();
        this.menuBarMediator = this.createSourceEditorMenuBarMediator();
        this.toolBar = this.createSourceEditorToolBar();
        this.tabbedPane = this.createSourceEditorTabbedPane(this);
        this.frame = this.getFrame();
    }

    public abstract EditorResourceFactory createEditorResourceFactory();

    public EditorResourceFactory getEditorResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = this.createEditorResourceFactory();
        }
        return this.resourceFactory;
    }

    public SourceEditorMediator(File filename) throws ClassCastException, IllegalAccessException, InstantiationException, ClassNotFoundException, UnsupportedLookAndFeelException {
        this();
        this.menuBarMediator.open(filename);
        this.menuBarMediator.updateMenu();
    }

    public SourceEditorMediator(URL url) throws ClassCastException, IllegalAccessException, InstantiationException, ClassNotFoundException, UnsupportedLookAndFeelException {
        this();
        this.menuBarMediator.open(url, false, null);
        this.menuBarMediator.updateMenu();
    }

    public JFrame getFrame() {
        if (this.frame == null) {
            this.frame = new SourceEditorFrame(this.menuBarMediator, this.toolBar, this.tabbedPane);
            this.frame.setTitle(this.getTitle());
            this.frame.setSize(800, 600);
            this.frame.setVisible(true);
        }
        return this.frame;
    }

    public SourceEditorToolBar getToolBar() {
        return this.toolBar;
    }

    public SourceEditorMenuBarMediator getMenuBarMediator() {
        return this.menuBarMediator;
    }

    public abstract String getTitle();

    public abstract SourceManager createSourceManager();

    public abstract SourceEditorMenuBarMediator createSourceEditorMenuBarMediator();

    public abstract SourceEditorToolBar createSourceEditorToolBar();

    public abstract SourceEditorTabbedPane createSourceEditorTabbedPane(SourceEditorMediator var1);

    public SourceEditorTabbedPane getSourceEditorTabbedPane() {
        return this.tabbedPane;
    }

    public SourceManager getSourceManager() {
        return this.sourceManager;
    }

    public NodeTreePane getCurrentTreePane() {
        return this.getSourceEditorTabbedPane().getCurrentSplitPane().getTreePane();
    }

    public JScrollPane getCurrentEditorScrollPane() {
        return this.getSourceEditorTabbedPane().getCurrentSplitPane().getEditorScrollPane();
    }

    public JComponent getCurrentEditorPane() {
        return this.getSourceEditorTabbedPane().getCurrentSplitPane().getEditorPane();
    }

    public abstract JPanel getBackgroundPanel();

    public void fireSourceChanged() {
        this.tabbedPane.updateCurrentTitle();
        this.menuBarMediator.updateMenu();
    }
}

