/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sf.sqs_xml.editor.base.modules.resource.EditorResource;
import net.sf.sqs_xml.editor.base.swing.EditorResourceFactory;
import net.sf.sqs_xml.editor.base.swing.NodeTreeSelectionModel;
import org.w3c.dom.Node;

public class SourceEditorTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static final long serialVersionUID = 0L;
    static Color SELECTED_BGCOLOR = new Color(40, 40, 200);
    static Color HIARACHICAL_SELECTED_BGCOLOR = new Color(230, 230, 255);
    static Color SELECTED_COLOR = new Color(180, 180, 180);
    static Color HIARACHICAL_SELECTED_COLOR = new Color(0, 0, 0);
    static Color NODENAME_COLOR = new Color(130, 130, 255);
    boolean hiarachicalSelected = false;
    EditorResourceFactory factory;

    public SourceEditorTreeCellRenderer(EditorResourceFactory factory) {
        this.factory = factory;
        this.setBorderSelectionColor(Color.green);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Node node = (Node)value;
        String localName = node.getLocalName();
        String uri = node.getNamespaceURI();
        String prefix = node.getPrefix();
        EditorResource resource = this.factory.getEditorResource(localName, uri);
        String name = null;
        this.setTextSelectionColor(NODENAME_COLOR);
        this.setTextNonSelectionColor(NODENAME_COLOR);
        if (resource == null) {
            name = prefix != null ? String.valueOf(prefix) + ":" + localName : localName;
        } else if (expanded || leaf) {
            name = resource.getName(node, expanded, leaf);
        } else {
            name = resource.getDigestText(node);
            this.setTextSelectionColor(Color.GRAY);
            this.setTextNonSelectionColor(Color.GRAY);
        }
        boolean isDecendant = ((NodeTreeSelectionModel)tree.getSelectionModel()).isHierachicalSelected(tree.getPathForRow(row));
        if (3 == node.getNodeType()) {
            this.setTextSelectionColor(Color.black);
            this.setTextNonSelectionColor(Color.black);
            if (isDecendant) {
                this.hiarachicalSelected = true;
                this.setBackgroundSelectionColor(HIARACHICAL_SELECTED_BGCOLOR);
                this.setTextSelectionColor(HIARACHICAL_SELECTED_COLOR);
                super.getTreeCellRendererComponent(tree, name, true, expanded, leaf, row, hasFocus);
            } else {
                this.hiarachicalSelected = false;
                this.setBackgroundSelectionColor(SELECTED_BGCOLOR);
                this.setTextSelectionColor(SELECTED_COLOR);
                super.getTreeCellRendererComponent(tree, name, sel, expanded, leaf, row, hasFocus);
            }
            if (resource != null) {
                this.setIcon(resource.icon);
            }
        } else {
            if (isDecendant) {
                this.hiarachicalSelected = true;
                this.setBackgroundSelectionColor(HIARACHICAL_SELECTED_BGCOLOR);
                super.getTreeCellRendererComponent(tree, name, true, expanded, leaf, row, hasFocus);
            } else {
                this.hiarachicalSelected = false;
                this.setBackgroundSelectionColor(SELECTED_BGCOLOR);
                this.setTextSelectionColor(SELECTED_COLOR);
                super.getTreeCellRendererComponent(tree, name, sel, expanded, leaf, row, hasFocus);
            }
            if (resource != null) {
                this.setIcon(resource.icon);
            }
        }
        return this;
    }

    public Icon getIcon(String localName, String uri) {
        EditorResource resource = this.factory.getEditorResource(localName, uri);
        if (resource != null) {
            return resource.icon;
        }
        return null;
    }

    public void paint(Graphics g) {
        if (this.selected) {
            g.setColor(SELECTED_BGCOLOR);
            g.fillRect(0, 0, this.getIcon().getIconWidth() + 4, this.getIcon().getIconHeight());
        }
        if (this.hiarachicalSelected) {
            g.setColor(HIARACHICAL_SELECTED_BGCOLOR);
            g.fillRect(0, 0, this.getIcon().getIconWidth() + 4, this.getIcon().getIconHeight());
        }
        super.paint(g);
    }
}

