/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.util.LinkedList;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TreeNodePathUtil {
    public static final String PATH_SEPARATOR = "|";

    public static TreePath createTreePath(Node target) {
        LinkedList<Node> list = new LinkedList<Node>();
        Node currentNode = target;
        while (currentNode != null) {
            list.addFirst(currentNode);
            currentNode = currentNode.getParentNode();
        }
        return new TreePath(list.toArray());
    }

    public static TreePath createTreePath(Node documentNode, String pathID) {
        LinkedList<Node> list = new LinkedList<Node>();
        String[] args = pathID.split("\\|");
        Node node = ((Document)documentNode).getFirstChild();
        list.add(documentNode);
        list.add(node);
        int i = 2;
        while (i < args.length) {
            int index = Integer.parseInt(args[i]);
            node = ((Element)node).getChildNodes().item(index);
            list.add(node);
            ++i;
        }
        return new TreePath(list.toArray());
    }

    public static String createPathID(TreePath path) {
        Object[] obj = path.getPath();
        String ret = "";
        int i = 1;
        while (i < obj.length) {
            ret = String.valueOf(ret) + PATH_SEPARATOR + TreeNodePathUtil.getNodeIndex((Node)obj[i]);
            ++i;
        }
        return ret;
    }

    public static String createPathID(Node node) {
        String ret = "";
        while (node.getParentNode() != null) {
            ret = PATH_SEPARATOR + TreeNodePathUtil.getNodeIndex(node) + ret;
            node = node.getParentNode();
        }
        return ret;
    }

    private static int getNodeIndex(Node node) {
        if (node.getParentNode() != null) {
            NodeList list = node.getParentNode().getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i) == node) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

