/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
import net.sf.sqs_xml.editor.base.swing.NodeTreePane;
import net.sf.sqs_xml.editor.base.swing.TreeNodePathUtil;
import net.sf.sqs_xml.editor.base.swing.TreeNodePopupMenu;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TreeNodePopupAdapter
implements ActionListener {
    private TreeNodePopupMenu menu;
    String pathID = null;
    boolean isClickedNode;
    Node root;

    TreeNodePopupAdapter(TreeNodePopupMenu menu, Node root, String pathID, boolean isClickedNode) {
        this.menu = menu;
        this.root = root;
        this.pathID = pathID;
        this.isClickedNode = isClickedNode;
    }

    public void actionPerformed(ActionEvent ev) {
        String[] commandArgs = ev.getActionCommand().split("\\s");
        String command = commandArgs[0];
        TreePath target = TreeNodePathUtil.createTreePath(this.root, commandArgs[1]);
        if (command.equals("d")) {
            this.cut();
        } else if (command.equals("c")) {
            this.copy();
        } else if (command.equals("b")) {
            this.insert(target, true);
        } else if (command.equals("i")) {
            this.insertWithin(target);
        } else if (command.equals("a")) {
            this.insert(target, false);
        } else if (command.equals("S")) {
            this.showAll(target);
        } else if (command.equals("H")) {
            this.hideAll(target);
        }
        this.menu.getTreePane().updateUI();
    }

    private List getRecentCutNode() {
        return this.menu.getTreePane().mediator.menuBarMediator.getRecentCutNode();
    }

    private void setRecentCutNode(List list) {
        this.menu.getTreePane().mediator.menuBarMediator.setRecentCutNode(list);
    }

    private boolean isReadOnly() {
        return this.menu.isReadOnly();
    }

    private void insert(TreePath path, boolean isInsertBeforeMode) {
        if (this.isReadOnly()) {
            return;
        }
        List recentCutNode = this.getRecentCutNode();
        if (recentCutNode == null || recentCutNode.size() == 0) {
            return;
        }
        NodeTreePane tree = this.menu.getTreePane();
        TreePath parentPath = path.getParentPath();
        Node currentNode = (Node)path.getLastPathComponent();
        Node parentNode = (Node)parentPath.getLastPathComponent();
        boolean appendMode = false;
        if (!isInsertBeforeMode) {
            Node nextNode = currentNode.getNextSibling();
            if (nextNode == null) {
                appendMode = true;
            } else {
                currentNode = nextNode;
            }
        }
        this.insertNodeCore(recentCutNode, tree, parentPath, currentNode, parentNode, appendMode);
        this.updateCurrentTitle(tree);
        tree.setupEditorPane(null);
    }

    private void updateCurrentTitle(NodeTreePane tree) {
        tree.mediator.tabbedPane.getCurrentEditingSource().setDirty(true);
        tree.mediator.tabbedPane.updateCurrentTitle();
    }

    private void insertNodeCore(List recentCutNode, NodeTreePane tree, TreePath parentPath, Node currentNode, Node parentNode, boolean appendMode) {
        Document document = tree.mediator.tabbedPane.getCurrentEditingSource().getDocument();
        TreePath[] paths = new TreePath[recentCutNode.size()];
        int i = 0;
        while (i < recentCutNode.size()) {
            TreePath insertedPath;
            Node insertedNode = document.importNode((Node)recentCutNode.get(i), true);
            paths[i] = insertedPath = parentPath.pathByAddingChild(insertedNode);
            if (appendMode) {
                this.menu.getTreePane().appendChildNode(parentNode, insertedNode);
            } else {
                this.menu.getTreePane().insertBefore(currentNode, parentNode, insertedNode);
            }
            tree.getModel().valueForPathChanged(parentPath, new TreeModelEvent((Object)this, parentPath, new int[]{this.getIndex(parentNode, insertedNode)}, new Object[]{insertedNode}));
            ++i;
        }
        i = 0;
        while (i < paths.length) {
            tree.getSelectionModel().addSelectionPath(paths[i]);
            ++i;
        }
    }

    private int getIndex(Node parent, Node children) {
        NodeList list = parent.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (children == list.item(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void insertWithin(TreePath path) {
        if (this.isReadOnly()) {
            return;
        }
        List recentCutNode = this.getRecentCutNode();
        if (recentCutNode == null || recentCutNode.size() == 0) {
            return;
        }
        TreePath[] paths = new TreePath[recentCutNode.size()];
        NodeTreePane tree = this.menu.getTreePane();
        Node currentNode = (Node)path.getLastPathComponent();
        int i = 0;
        while (i < recentCutNode.size()) {
            TreePath insertedPath;
            Node insertedNode = ((Node)recentCutNode.get(i)).cloneNode(true);
            paths[i] = insertedPath = path.pathByAddingChild(insertedNode);
            this.menu.getTreePane().appendChildNode(currentNode, insertedNode);
            tree.getSelectionModel().addSelectionPath(insertedPath);
            ++i;
        }
        tree.getModel().valueForPathChanged(path, currentNode);
        this.updateCurrentTitle(tree);
        tree.setupEditorPane(paths);
    }

    private void cut() {
        this.cutcopy(this.pathID, true);
    }

    private void copy() {
        this.cutcopy(this.pathID, false);
    }

    private void cutcopy(String pathID, boolean isDeleteMode) {
        NodeTreePane tree = this.menu.getTreePane();
        TreePath[] paths = null;
        paths = this.isClickedNode ? new TreePath[]{TreeNodePathUtil.createTreePath(this.root, pathID)} : tree.getSelectionModel().getSelectionPaths();
        this.cutcopy(paths, tree, isDeleteMode);
    }

    private void cutcopy(TreePath[] paths, NodeTreePane tree, boolean isDeleteMode) {
        if (this.isNodeDeleteProihibited(isDeleteMode, tree, paths)) {
            return;
        }
        List recentCutNode = this.resetRecentCutNode();
        this.cutcopy(isDeleteMode, tree, paths, recentCutNode);
        if (!this.isReadOnly() && isDeleteMode) {
            this.updateCurrentTitle(tree);
            tree.setupEditorPane(null);
        }
    }

    private boolean isNodeDeleteProihibited(boolean isDeleteMode, NodeTreePane tree, TreePath[] paths) {
        return paths.length == 0 || isDeleteMode && paths.length > 0 && tree.mediator.getMenuBarMediator().avoidNodeDelete(paths.length);
    }

    private List resetRecentCutNode() {
        LinkedList recentCutNode = this.getRecentCutNode();
        if (recentCutNode == null) {
            recentCutNode = new LinkedList();
            this.setRecentCutNode(recentCutNode);
        } else {
            recentCutNode.clear();
        }
        return recentCutNode;
    }

    private void cutcopy(boolean isDeleteMode, NodeTreePane tree, TreePath[] paths, List recentCutNode) {
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            Node leaf = (Node)path.getLastPathComponent();
            Node parent = (Node)path.getParentPath().getLastPathComponent();
            recentCutNode.add(leaf);
            if (!this.isReadOnly() && isDeleteMode) {
                parent.removeChild(leaf);
                tree.getSelectionModel().removeSelectionPath(path);
            }
            ++i;
        }
    }

    private void showAll(TreePath path) {
        NodeTreePane tree = this.menu.getTreePane();
        TreePath[] paths = tree.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            tree.expandDecendant(paths[i]);
            ++i;
        }
    }

    private void hideAll(TreePath path) {
        boolean doCollapsed = false;
        NodeTreePane tree = this.menu.getTreePane();
        if (tree.isCollapsed(path)) {
            return;
        }
        TreePath[] paths = tree.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            TreePath branchPath = paths[i];
            if (!tree.isCollapsed(branchPath)) {
                NodeList branchObjectList = ((Node)branchPath.getLastPathComponent()).getChildNodes();
                int j = 0;
                while (j < branchObjectList.getLength()) {
                    TreePath subBranchPath = branchPath.pathByAddingChild(branchObjectList.item(j));
                    if (!tree.isCollapsed(subBranchPath)) {
                        tree.collapsePath(subBranchPath);
                        doCollapsed = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!doCollapsed) {
            tree.collapsePath(path);
        }
    }
}

