/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.Component;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import net.sf.sqs_xml.editor.base.swing.NodeTreePane;
import net.sf.sqs_xml.editor.base.swing.TreeNodePathUtil;
import net.sf.sqs_xml.editor.base.swing.TreeNodePopupAdapter;
import org.w3c.dom.Node;

public class TreeNodePopupMenu
extends JPopupMenu {
    public static final long serialVersionUID = 0L;
    private final NodeTreePane treePane;
    private TreeNodePopupAdapter listener;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    JMenuItem insertUpperMenu = null;
    JMenuItem insertWithinMenu = null;
    JMenuItem insertLowerMenu = null;
    public static String SELECTED_NODE = "\u9078\u629e\u3057\u305f\u30ce\u30fc\u30c9";
    public static String CLICKED_NODE = "\u30af\u30ea\u30c3\u30af\u3057\u305f\u30ce\u30fc\u30c9";
    String target = null;

    private TreeNodePopupMenu(NodeTreePane tree, boolean isClickedNode) {
        this.treePane = tree;
        this.target = isClickedNode ? CLICKED_NODE : SELECTED_NODE;
    }

    TreeNodePopupMenu(NodeTreePane tree, TreePath treePath, boolean isClickedNode) {
        this(tree, isClickedNode);
        String pathID = TreeNodePathUtil.createPathID(treePath);
        this.listener = new TreeNodePopupAdapter(this, (Node)treePath.getPath()[0], pathID, isClickedNode);
        JMenuItem showAllMenuItem = this.createPopupMenuItem(String.valueOf(this.target) + "\u306e\u300c\u679d\u3092\u8868\u793a\u300d", "S " + pathID);
        JMenuItem hideAllMenuItem = this.createPopupMenuItem(String.valueOf(this.target) + "\u306e\u300c\u679d\u3092\u96a0\u3059\u300d", "H " + pathID);
        this.add(showAllMenuItem);
        this.add(hideAllMenuItem);
        this.addSeparator();
        this.cutMenuItem = this.createPopupMenuItem(String.valueOf(this.target) + "\u3092\u300c\u30ab\u30c3\u30c8\u300d", "d " + pathID);
        this.copyMenuItem = this.createPopupMenuItem(String.valueOf(this.target) + "\u3092\u300c\u30b3\u30d4\u30fc\u300d", "c " + pathID);
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        if (this.isReadOnly()) {
            this.cutMenuItem.setEnabled(false);
        }
        this.add(this.cutMenuItem);
        this.add(this.copyMenuItem);
        this.addSeparator();
        this.insertUpperMenu = this.createPopupMenuItem("\u2191  " + CLICKED_NODE + "\u306e\u300c\u524d\u300d\u306b\u8cbc\u308a\u4ed8\u3051", "b " + pathID);
        this.insertWithinMenu = this.createPopupMenuItem("\u2192  " + CLICKED_NODE + "\u306e\u300c\u679d\u300d\u3068\u3057\u3066\u8cbc\u308a\u4ed8\u3051", "i " + pathID);
        this.insertLowerMenu = this.createPopupMenuItem("\u2193  " + CLICKED_NODE + "\u306e\u300c\u5f8c\u300d\u306b\u8cbc\u308a\u4ed8\u3051", "a " + pathID);
        this.insertLowerMenu.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.add(this.insertUpperMenu);
        this.add(this.insertWithinMenu);
        this.add(this.insertLowerMenu);
        this.setPopupSize(300, 150);
        this.updateMenu();
    }

    public void show(Component invoker, int x, int y) {
        this.updateMenu();
        super.show(invoker, x, y);
    }

    public void updateMenu() {
        List recentCutNodes = this.treePane.mediator.menuBarMediator.getRecentCutNode();
        if (recentCutNodes != null && recentCutNodes.size() > 0) {
            this.setInsertMenuEnabled(true);
        } else {
            this.setInsertMenuEnabled(false);
        }
        if (this.isReadOnly()) {
            this.insertUpperMenu.setEnabled(false);
            this.insertWithinMenu.setEnabled(false);
            this.insertLowerMenu.setEnabled(false);
        }
    }

    private void setInsertMenuEnabled(boolean isEnabled) {
        this.insertUpperMenu.setEnabled(isEnabled);
        this.insertWithinMenu.setEnabled(isEnabled);
        this.insertLowerMenu.setEnabled(isEnabled);
    }

    boolean isReadOnly() {
        return this.getTreePane().mediator.getSourceEditorTabbedPane().getCurrentEditingSource().isReadOnly();
    }

    public NodeTreePane getTreePane() {
        return this.treePane;
    }

    private JMenuItem createPopupMenuItem(String label, String command) {
        JMenuItem item = new JMenuItem(label);
        item.setActionCommand(command);
        item.addActionListener(this.listener);
        return item;
    }

    public JMenuItem getCutMenuItem() {
        return this.cutMenuItem;
    }

    public JMenuItem getCopyMenuItem() {
        return this.copyMenuItem;
    }
}

