/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.modules.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.undo.UndoManager;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.EditorUtil;
import net.sf.sqs_xml.editor.base.modules.UpdateListener;
import net.sf.sqs_xml.editor.base.modules.UpdateTarget;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractNodeEditorPanel;
import net.sf.sqs_xml.editor.sqs.modules.panel.SelectFormItemListModel;
import net.sf.sqs_xml.swing.EditMenuTextField;
import org.w3c.dom.Element;

public class SelectFormItemListPanel
extends AbstractNodeEditorPanel
implements UpdateTarget {
    public static final long serialVersionUID = 0L;
    SelectFormItemListModel model;
    Item[] itemList = null;
    Icon itemIcon;
    Box itemListFormInnerPane;
    SelectFormItemListPanel self = this;
    Thread invalidValuesAlartThread = null;

    public SelectFormItemListPanel(AbstractNodeEditor editor) {
        super(editor);
        this.model = new SelectFormItemListModel(editor.getMediator(), editor.getSource(), (Element)editor.getNode());
        this.itemIcon = editor.getMediator().getCurrentTreePane().getIcon("item", "http://www.w3.org/2002/xforms");
        this.itemListFormInnerPane = Box.createVerticalBox();
        JPanel itemListForm = new JPanel();
        itemListForm.setBorder(new TitledBorder(EditorUtil.LOWERED_BORDER, "\u9078\u629e\u80a2"));
        itemListForm.setBackground(editor.getResource().bgcolor);
        itemListForm.setLayout(new BorderLayout());
        itemListForm.add((Component)this.createItemListScrollPanel(), "Center");
        this.setBackground(editor.getResource().bgcolor);
        this.add(itemListForm);
        this.initialize();
        this.initSize();
    }

    public int getPreferredHeight() {
        return 40;
    }

    public boolean validateValues() {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < this.itemList.length) {
            Item item = this.itemList[i];
            String value = item.getValueText();
            if (set.contains(value)) {
                item.setValueText("?" + value);
                return false;
            }
            set.add(value);
            ++i;
        }
        return true;
    }

    private JScrollPane createItemListScrollPanel() {
        final JScrollPane itemListFormScrollPane = new JScrollPane(this.itemListFormInnerPane);
        itemListFormScrollPane.setWheelScrollingEnabled(true);
        itemListFormScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ev) {
                if (itemListFormScrollPane != null && SelectFormItemListPanel.this.model != null) {
                    int increment = SelectFormItemListPanel.this.itemListFormInnerPane.getHeight() / SelectFormItemListPanel.this.model.size();
                    itemListFormScrollPane.getVerticalScrollBar().setUnitIncrement(increment);
                }
            }
        });
        return itemListFormScrollPane;
    }

    public synchronized void initialize() {
        this.itemListFormInnerPane.removeAll();
        this.itemList = new Item[this.model.size()];
        int i = 0;
        while (i < this.model.size()) {
            Item item;
            this.itemList[i] = item = this.createItem(i);
            this.itemListFormInnerPane.add(item);
            ++i;
        }
    }

    public Item createItem(int i) {
        return new Item(this, i);
    }

    public synchronized Item get(int index) {
        return this.itemList[index];
    }

    public boolean updateNodeValue() {
        boolean isUpdated = false;
        if (!this.validateValues()) {
            this.invalidValuesAlartThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SelectFormItemListPanel selectFormItemListPanel = SelectFormItemListPanel.this.self;
                    synchronized (selectFormItemListPanel) {
                        JOptionPane.showMessageDialog(SelectFormItemListPanel.this.self, "\u9078\u629e\u80a2\u306e\u5024\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\uff01", "alert", 0);
                        SelectFormItemListPanel.this.invalidValuesAlartThread = null;
                    }
                }
            };
            if (this.invalidValuesAlartThread != null) {
                this.invalidValuesAlartThread.start();
            }
            return true;
        }
        int i = 0;
        while (i < this.itemList.length) {
            if (this.itemList[i].updateNodeValue()) {
                isUpdated = true;
            }
            ++i;
        }
        if (isUpdated) {
            this.getEditor().updateNodeValue(true);
        }
        return isUpdated;
    }

    public class Item
    extends JPanel {
        public static final long serialVersionUID = 0L;
        PopupMenu popupMenu;
        int index;
        EditMenuTextField valueTextField;
        EditMenuTextField labelTextField;
        UpdateListener updateListener;
        JComponent itemFormWest;

        Item(AbstractNodeEditorPanel itemListForm, int index) {
            this.index = index;
            this.updateListener = new UpdateListener(SelectFormItemListPanel.this.self);
            this.popupMenu = new PopupMenu(index);
            this.setLayout(new BorderLayout());
            this.setBackground(SelectFormItemListPanel.this.getEditor().getResource().bgcolor);
            this.itemFormWest = this.createFormItemWest();
            this.add((Component)this.itemFormWest, "West");
            this.labelTextField = this.createFormItemCenter();
            this.add((Component)this.labelTextField, "Center");
            this.setPreferredSize(new Dimension(340, 20));
            this.setSize(new Dimension(340, 20));
            this.addMouseListener(this.popupMenu.getMouseListener());
        }

        public void setSelectedBackGroundColor(boolean isSelected) {
            if (isSelected) {
                this.setBackground(SelectFormItemListPanel.this.getEditor().getResource().bgcolor.brighter());
            } else {
                this.setBackground(SelectFormItemListPanel.this.getEditor().getResource().bgcolor);
            }
        }

        JTextField getLabelTextField() {
            return this.labelTextField;
        }

        public boolean updateNodeValue() {
            return SelectFormItemListPanel.this.model.updateNodeValue(this.index, this.labelTextField.getText(), this.valueTextField.getText());
        }

        public String getValueText() {
            return this.valueTextField.getText();
        }

        public void setValueText(String text) {
            this.valueTextField.setText(text);
        }

        private JComponent createFormItemWest() {
            this.valueTextField = new EditMenuTextField();
            this.valueTextField.setSize(2, 1);
            this.valueTextField.setText(SelectFormItemListPanel.this.model.getValue(this.index));
            this.valueTextField.setBackground(this.getBackground());
            this.valueTextField.setEditable(true);
            this.valueTextField.addFocusListener(this.updateListener);
            this.valueTextField.setPreferredSize(new Dimension(16, 14));
            this.valueTextField.setUndoManager(new UndoManager());
            Box itemFormWest = Box.createHorizontalBox();
            itemFormWest.add(new JLabel(SelectFormItemListPanel.this.itemIcon));
            itemFormWest.add(this.valueTextField);
            itemFormWest.add(new JLabel(":"));
            if (SelectFormItemListPanel.this.getEditor().getSource().isReadOnly()) {
                this.valueTextField.setEnabled(false);
            }
            return itemFormWest;
        }

        private EditMenuTextField createFormItemCenter() {
            this.labelTextField = new EditMenuTextField();
            this.labelTextField.setSize(10, 1);
            this.labelTextField.setText(SelectFormItemListPanel.this.model.getLabel(this.index));
            this.labelTextField.addFocusListener(this.updateListener);
            this.labelTextField.setUndoManager(new UndoManager());
            if (SelectFormItemListPanel.this.getEditor().getSource().isReadOnly()) {
                this.labelTextField.setEnabled(false);
            }
            return this.labelTextField;
        }

        class PopupMenu
        extends JPopupMenu {
            public static final long serialVersionUID = 0L;
            private PopupAdapter listener;
            private JMenuItem deleteButton;
            private MouseAdapter mouseAdapter = new MouseAdapter(this){
                final /* synthetic */ PopupMenu this$2;
                {
                    this.this$2 = popupMenu;
                }

                public void mouseEntered(MouseEvent e) {
                    PopupMenu.access$0(this.this$2).setSelectedBackGroundColor(true);
                }

                public void mouseExited(MouseEvent e) {
                    PopupMenu.access$0(this.this$2).setSelectedBackGroundColor(false);
                }
            };

            PopupMenu(int index) {
                this.setPopupSize(300, 70);
                this.addMouseListener(this.mouseAdapter);
                this.listener = new PopupAdapter(this);
                JMenuItem insertBeforeButton = this.createPopupMenuItem("\u3053\u306e\u9078\u629e\u80a2\u306e\u300c\u524d\u300d\u306b\u65b0\u3057\u3044\u9078\u629e\u80a2\u3092\u633f\u5165", "b " + index);
                JMenuItem insertAfterButton = this.createPopupMenuItem("\u3053\u306e\u9078\u629e\u80a2\u306e\u300c\u5f8c\u300d\u306b\u65b0\u3057\u3044\u9078\u629e\u80a2\u3092\u633f\u5165", "a " + index);
                this.deleteButton = this.createPopupMenuItem("\u3053\u306e\u9078\u629e\u80a2\u3092\u524a\u9664", "d " + index);
                this.add(insertBeforeButton);
                this.add(insertAfterButton);
                this.addSeparator();
                this.add(this.deleteButton);
            }

            private JMenuItem createPopupMenuItem(String label, String command) {
                JMenuItem item = new JMenuItem(label);
                item.setActionCommand(command);
                item.addActionListener(this.listener);
                item.addMouseListener(this.mouseAdapter);
                return item;
            }

            MouseAdapter getMouseListener() {
                return this.listener;
            }

            public JMenuItem getDeleteButton() {
                return this.deleteButton;
            }

            class PopupAdapter
            extends MouseAdapter
            implements ActionListener {
                private JPopupMenu popupMenu;

                PopupAdapter(JPopupMenu commandPopup) {
                    this.popupMenu = commandPopup;
                }

                public void actionPerformed(ActionEvent ev) {
                    String[] commandArgs = ev.getActionCommand().split("\\s");
                    String command = commandArgs[0];
                    int target = Integer.parseInt(commandArgs[1]);
                    if (command.equals("d")) {
                        this.delete(target);
                    } else if (command.equals("b")) {
                        this.insertBefore(target);
                    } else if (command.equals("a")) {
                        this.insertAfter(target);
                    } else {
                        return;
                    }
                    Item.this.setSelectedBackGroundColor(false);
                    SelectFormItemListPanel.this.initialize();
                    if (command.equals("b")) {
                        SelectFormItemListPanel.this.get(target).getLabelTextField().requestFocus();
                    } else if (command.equals("a")) {
                        SelectFormItemListPanel.this.get(target + 1).getLabelTextField().requestFocus();
                    }
                    SelectFormItemListPanel.this.getEditor().updateNodeValue(true);
                    SelectFormItemListPanel.this.getEditor().updateUI();
                    SelectFormItemListPanel.this.getEditor().getMediator().getCurrentTreePane().updateUI();
                }

                private void insertAfter(int target) {
                    if (target == ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.size() - 1) {
                        ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.add("", "", 1);
                    } else {
                        ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.insert(target + 1, "", "", 1);
                    }
                    PopupMenu.this.getDeleteButton().setEnabled(true);
                }

                private void insertBefore(int target) {
                    ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.insert(target, "", "", 1);
                    PopupMenu.this.getDeleteButton().setEnabled(true);
                }

                private void delete(int target) {
                    if (1 < ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.size()) {
                        ((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.remove(target);
                        if (((Item)((PopupMenu)PopupMenu.this).Item.this).SelectFormItemListPanel.this.model.size() == 1) {
                            PopupMenu.this.getDeleteButton().setEnabled(false);
                        }
                    }
                }

                public void mousePressed(MouseEvent e) {
                    Item.this.setSelectedBackGroundColor(true);
                    this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                    Item.this.setSelectedBackGroundColor(true);
                }

                public void mouseExited(MouseEvent e) {
                    if (!this.popupMenu.isVisible()) {
                        Item.this.setSelectedBackGroundColor(false);
                    }
                }
            }
        }
    }
}

