/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.image;

import java.awt.geom.Point2D;
import java.awt.image.Raster;
import net.sf.sqs_xml.image.RasterSource;

public class ImageTranslationFilter
extends RasterSource {
    Point2D[] master;
    Point2D[] guide;
    double masterWidth;
    double masterHeight;
    double ox;
    double oy;
    double ax;
    double ay;
    double bx;
    double by;
    double cx;
    double cy;
    double dx;
    double dy;

    public ImageTranslationFilter(Raster src, Point2D[] master, Point2D[] _guide) {
        super(src);
        this.init(master, _guide);
    }

    public ImageTranslationFilter(Point2D[] master, Point2D[] _guide) {
        this.init(master, _guide);
    }

    public ImageTranslationFilter(RasterSource source, Point2D[] master, Point2D[] _guide) {
        super(source);
        this.init(master, _guide);
    }

    private void init(Point2D[] master, Point2D[] _guide) {
        this.master = master;
        this.guide = new Point2D[4];
        int i = 0;
        while (i < 4) {
            this.guide[i] = new Point2D.Double(_guide[i].getX(), _guide[i].getY());
            ++i;
        }
        this.masterWidth = master[1].getX() - master[0].getX();
        this.masterHeight = master[2].getY() - master[0].getY();
        this.ox = master[0].getX();
        this.oy = master[0].getY();
        if (this.guide == null || this.guide.length < 4 || this.guide[0] == null || this.guide[1] == null || this.guide[2] == null || this.guide[3] == null) {
            return;
        }
        double cx = this.guide[3].getX() - this.guide[2].getX();
        double cy = this.guide[3].getY() - this.guide[2].getY();
        double s = (master[0].getX() - master[2].getX()) / this.masterWidth;
        this.guide[2].setLocation(this.guide[2].getX() + cx * s, this.guide[2].getY() + cy * s);
        this.guide[3].setLocation(this.guide[3].getX() + cx * s, this.guide[3].getY() + cy * s);
        this.ax = this.guide[1].getX() - this.guide[0].getX();
        this.ay = this.guide[1].getY() - this.guide[0].getY();
        this.bx = this.guide[2].getX() - this.guide[0].getX();
        this.by = this.guide[2].getY() - this.guide[0].getY();
        this.cx = this.guide[3].getX() - this.guide[2].getX();
        this.cy = this.guide[3].getY() - this.guide[2].getY();
        this.dx = this.guide[3].getX() - this.guide[1].getX();
        this.dy = this.guide[3].getY() - this.guide[1].getY();
    }

    public Point2D getPoint(double x, double y, double scale, Point2D ret) {
        double s = (x - this.ox) / this.masterWidth;
        double t = (y - this.oy) / this.masterHeight;
        double aax = this.guide[0].getX() + this.ax * s;
        double aay = this.guide[0].getY() + this.ay * t;
        double bbx = this.guide[0].getX() + this.bx * s;
        double bby = this.guide[0].getY() + this.by * t;
        double acx = this.guide[2].getX() + this.cx * s - aax;
        double acy = this.guide[2].getY() + this.cy * t - aay;
        double bdx = this.guide[1].getX() + this.dx * s - bbx;
        double bdy = this.guide[1].getY() + this.dy * t - bby;
        double q = (acx * (bby - aay) - acy * (bbx - aax)) / (acy * bdx - acx * bdy);
        double p = (bbx + bdx * q - aax) / acx;
        if (ret == null) {
            return new Point2D.Double(aax + acx * p, aay + acy * p);
        }
        ret.setLocation(aax + acx * p, aay + acy * p);
        return ret;
    }

    public Point2D getPoint(int x, int y) {
        return this.getPoint(x, y, 1.0, new Point2D.Double());
    }

    public int getRGBColor(Point2D p) {
        return super.getRGBColor((int)p.getX(), (int)p.getY());
    }

    public int getRGBColor(int x, int y) {
        return this.getRGBColor(this.getPoint(x, y));
    }

    public int getRGBColor(int x, int y, Point2D p) {
        return this.getRGBColor(this.getPoint(x, y, 1.0, p));
    }

    public int getRGBColor(double x, double y, Point2D p) {
        return this.getRGBColor(this.getPoint(x, y, 1.0, p));
    }
}

