/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

class EditMenuFeature {
    public static final long serialVersionUID = 0L;
    JPopupMenu popup;
    JMenuItem undoMenu;
    JMenuItem redoMenu;
    UndoManager undo = null;
    JTextComponent textcomp = null;

    public EditMenuFeature(JTextComponent textcomp) {
        this.textcomp = textcomp;
        this.initPopupMenu();
        this.initUndoFeature();
        textcomp.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3 && !EditMenuFeature.this.popup.isVisible()) {
                    EditMenuFeature.this.showPopup(e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && !EditMenuFeature.this.popup.isVisible()) {
                    EditMenuFeature.this.showPopup(e.getX(), e.getY());
                }
            }
        });
    }

    void showPopup(int x, int y) {
        this.popup.show(this.textcomp, x, y);
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undo = undoManager;
    }

    private void initPopupMenu() {
        this.popup = new JPopupMenu();
        this.undoMenu = new JMenuItem("\u5143\u306b\u623b\u3059  Ctrl-Z");
        this.redoMenu = new JMenuItem("\u3084\u308a\u76f4\u3057  Ctrl-Y");
        JMenuItem cutMenu = new JMenuItem("\u30ab\u30c3\u30c8    Ctrl-X");
        JMenuItem copyMenu = new JMenuItem("\u30b3\u30d4\u30fc    Ctrl-C");
        JMenuItem pasteMenu = new JMenuItem("\u8cbc\u308a\u4ed8\u3051  Ctrl-V");
        JMenuItem selectAllMenu = new JMenuItem("\u5168\u3066\u9078\u629e  Ctrl-A");
        this.undoMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EditMenuFeature.this.undo();
            }
        });
        this.redoMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EditMenuFeature.this.redo();
            }
        });
        cutMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EditMenuFeature.this.textcomp.cut();
            }
        });
        copyMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EditMenuFeature.this.textcomp.copy();
            }
        });
        pasteMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EditMenuFeature.this.textcomp.paste();
            }
        });
        selectAllMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EditMenuFeature.this.textcomp.selectAll();
            }
        });
        this.popup.add(this.undoMenu);
        this.popup.add(this.redoMenu);
        this.popup.addSeparator();
        this.popup.add(cutMenu);
        this.popup.add(copyMenu);
        this.popup.add(pasteMenu);
        this.popup.addSeparator();
        this.popup.add(selectAllMenu);
        this.undoMenu.setEnabled(false);
        this.redoMenu.setEnabled(false);
    }

    public void addEdit(UndoableEdit edit) {
        if (this.undo != null) {
            this.undo.addEdit(edit);
        }
    }

    public void undo() {
        try {
            if (this.undo != null && this.undo.canUndo()) {
                this.undo.undo();
                this.refreshEnabledStatus();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            if (this.undo != null && this.undo.canRedo()) {
                this.undo.redo();
                this.refreshEnabledStatus();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    void refreshEnabledStatus() {
        if (this.undo != null) {
            if (this.undo.canRedo()) {
                this.redoMenu.setEnabled(true);
            }
            if (this.undo.canUndo()) {
                this.undoMenu.setEnabled(true);
            }
        }
    }

    private void initUndoFeature() {
        Document doc = this.textcomp.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent ev) {
                EditMenuFeature.this.undoMenu.setEnabled(true);
                EditMenuFeature.this.addEdit(ev.getEdit());
                EditMenuFeature.this.refreshEnabledStatus();
            }
        });
        this.textcomp.getActionMap().put("Undo", new AbstractAction("Undo"){
            public static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent ev) {
                EditMenuFeature.this.undo();
            }
        });
        this.textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.textcomp.getActionMap().put("Redo", new AbstractAction("Redo"){
            public static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent ev) {
                EditMenuFeature.this.redo();
            }
        });
        this.textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }
}

