/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.swing;

import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import net.sf.sqs_xml.swing.CompTitledBorder;
import net.sf.sqs_xml.swing.IconTitledBorder;
import net.sf.sqs_xml.swing.StateTransmitter;

public class IconTitledPane
extends JPanel {
    public static final long serialVersionUID = 0L;
    protected CompTitledBorder iconBorder;
    protected JComponent component;
    protected Box panel;
    protected boolean transmittingAllowed;
    protected StateTransmitter transmitter;
    String title;

    public void initialize(Icon icon, String title, Border border) {
        this.initialize(icon, title, border, null);
    }

    public void initialize(Icon icon, String title, Border border, JPopupMenu menu) {
        this.title = title;
        this.iconBorder = new IconTitledBorder(icon, title, border, menu);
        this.component = this.iconBorder.getTitleComponent();
        this.panel = Box.createVerticalBox();
        this.setLayout(null);
        this.setBorder(this.iconBorder);
        super.add(this.component);
        super.add(this.panel);
        this.transmittingAllowed = false;
        this.transmitter = null;
    }

    public JComponent getTitleComponent() {
        return this.component;
    }

    public void setTitleComponent(JComponent newComponent) {
        this.remove(this.component);
        this.add(newComponent);
        this.iconBorder.setTitleComponent(newComponent);
        this.component = newComponent;
    }

    public Box getContentPane() {
        return this.panel;
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        Rectangle compR = this.iconBorder.getComponentRect(rect, insets);
        this.component.setBounds(compR);
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        this.panel.setBounds(rect);
    }

    public void setTransmittingAllowed(boolean enable) {
        this.transmittingAllowed = enable;
    }

    public boolean getTransmittingAllowed() {
        return this.transmittingAllowed;
    }

    public void setTransmitter(StateTransmitter transmitter) {
        this.transmitter = transmitter;
    }

    public StateTransmitter getTransmitter() {
        return this.transmitter;
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (this.transmittingAllowed && this.transmitter != null) {
            this.transmitter.setChildrenEnabled(enable);
        }
    }

    public void add(JComponent comp) {
        this.getContentPane().add(comp);
    }
}

