/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout.hyphenation;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.fop.layout.hyphenation.ByteVector;
import org.apache.fop.layout.hyphenation.Hyphenation;
import org.apache.fop.layout.hyphenation.HyphenationException;
import org.apache.fop.layout.hyphenation.PatternConsumer;
import org.apache.fop.layout.hyphenation.PatternParser;
import org.apache.fop.layout.hyphenation.TernaryTree;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer,
Serializable {
    protected ByteVector vspace;
    protected HashMap stoplist = new HashMap(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String values) {
        int n = values.length();
        int m = (n & 1) == 1 ? (n >> 1) + 2 : (n >> 1) + 1;
        int offset = this.vspace.alloc(m);
        byte[] va = this.vspace.getArray();
        int i = 0;
        while (i < n) {
            int j = i >> 1;
            byte v = (byte)(values.charAt(i) - 48 + 1 & 0xF);
            va[j + offset] = (i & 1) == 1 ? (byte)(va[j + offset] | v) : (byte)(v << 4);
            ++i;
        }
        va[m - 1 + offset] = 0;
        return offset;
    }

    protected String unpackValues(int k) {
        StringBuffer buf = new StringBuffer();
        byte v = this.vspace.get(k++);
        while (v != 0) {
            char c = (char)((v >>> 4) - 1 + 48);
            buf.append(c);
            c = (char)(v & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001' + 48);
            buf.append(c);
            v = this.vspace.get(k++);
        }
        return buf.toString();
    }

    public void loadPatterns(String filename) throws HyphenationException {
        PatternParser pp = new PatternParser(this);
        this.ivalues = new TernaryTree();
        pp.parse(filename);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String pat) {
        int k = super.find(pat);
        if (k >= 0) {
            return this.unpackValues(k);
        }
        return "";
    }

    protected int hstrcmp(char[] s, int si, char[] t, int ti) {
        while (s[si] == t[ti]) {
            if (s[si] == '\u0000') {
                return 0;
            }
            ++si;
            ++ti;
        }
        if (t[ti] == '\u0000') {
            return 0;
        }
        return s[si] - t[ti];
    }

    protected byte[] getValues(int k) {
        StringBuffer buf = new StringBuffer();
        byte v = this.vspace.get(k++);
        while (v != 0) {
            char c = (char)((v >>> 4) - 1);
            buf.append(c);
            c = (char)(v & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001');
            buf.append(c);
            v = this.vspace.get(k++);
        }
        byte[] res = new byte[buf.length()];
        int i = 0;
        while (i < res.length) {
            res[i] = (byte)buf.charAt(i);
            ++i;
        }
        return res;
    }

    protected void searchPatterns(char[] word, int index, byte[] il) {
        int i = index;
        char sp = word[i];
        char p = this.root;
        block0: while (p > '\u0000' && p < this.sc.length) {
            byte[] values;
            if (this.sc[p] == '\uffff') {
                if (this.hstrcmp(word, i, this.kv.getArray(), this.lo[p]) == 0) {
                    values = this.getValues(this.eq[p]);
                    int j = index;
                    int k = 0;
                    while (k < values.length) {
                        if (j < il.length && values[k] > il[j]) {
                            il[j] = values[k];
                        }
                        ++j;
                        ++k;
                    }
                }
                return;
            }
            int d = sp - this.sc[p];
            if (d == 0) {
                if (sp == '\u0000') break;
                sp = word[++i];
                char q = p = this.eq[p];
                while (q > '\u0000' && q < this.sc.length) {
                    if (this.sc[q] == '\uffff') continue block0;
                    if (this.sc[q] == '\u0000') {
                        values = this.getValues(this.eq[q]);
                        int j = index;
                        int k = 0;
                        while (k < values.length) {
                            if (j < il.length && values[k] > il[j]) {
                                il[j] = values[k];
                            }
                            ++j;
                            ++k;
                        }
                        continue block0;
                    }
                    q = this.lo[q];
                }
                continue;
            }
            char c = p = d < 0 ? this.lo[p] : this.hi[p];
        }
    }

    public Hyphenation hyphenate(String word, int remainCharCount, int pushCharCount) {
        char[] w = word.toCharArray();
        return this.hyphenate(w, 0, w.length, remainCharCount, pushCharCount);
    }

    public Hyphenation hyphenate(char[] w, int offset, int len, int remainCharCount, int pushCharCount) {
        char[] word = new char[len + 3];
        char[] c = new char[2];
        int i = 1;
        while (i <= len) {
            c[0] = w[offset + i - 1];
            int nc = this.classmap.find(c, 0);
            if (nc < 0) {
                return null;
            }
            word[i] = (char)nc;
            ++i;
        }
        int[] result = new int[len + 1];
        int k = 0;
        String sw = new String(word, 1, len);
        if (this.stoplist.containsKey(sw)) {
            ArrayList hw = (ArrayList)this.stoplist.get(sw);
            int j = 0;
            i = 0;
            while (i < hw.size()) {
                Object o = hw.get(i);
                if (o instanceof String && (j += ((String)o).length()) >= remainCharCount && j < len - pushCharCount) {
                    result[k++] = j;
                }
                ++i;
            }
        } else {
            word[0] = 46;
            word[len + 1] = 46;
            word[len + 2] = '\u0000';
            byte[] il = new byte[len + 3];
            i = 0;
            while (i < len + 1) {
                this.searchPatterns(word, i, il);
                ++i;
            }
            i = 0;
            while (i < len) {
                if ((il[i + 1] & 1) == 1 && i >= remainCharCount && i <= len - pushCharCount) {
                    result[k++] = i;
                }
                ++i;
            }
        }
        if (k > 0) {
            int[] res = new int[k];
            System.arraycopy(result, 0, res, 0, k);
            return new Hyphenation(new String(w, offset, len), res);
        }
        return null;
    }

    public void addClass(String chargroup) {
        if (chargroup.length() > 0) {
            char equivChar = chargroup.charAt(0);
            char[] key = new char[2];
            key[1] = '\u0000';
            int i = 0;
            while (i < chargroup.length()) {
                key[0] = chargroup.charAt(i);
                this.classmap.insert(key, 0, equivChar);
                ++i;
            }
        }
    }

    public void addException(String word, ArrayList hyphenatedword) {
        this.stoplist.put(word, hyphenatedword);
    }

    public void addPattern(String pattern, String ivalue) {
        int k = this.ivalues.find(ivalue);
        if (k <= 0) {
            k = this.packValues(ivalue);
            this.ivalues.insert(ivalue, (char)k);
        }
        this.insert(pattern, (char)k);
    }

    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) throws Exception {
        ht = null;
        minCharCount = 2;
        in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            block32: {
                System.out.print("l:\tload patterns from XML\nL:\tload patterns from serialized object\ns:\tset minimun character count\nw:\twrite hyphenation tree to object file\nh:\thyphenate\nf:\tfind pattern\nb:\tbenchmark\nq:\tquit\n\nCommand:");
                token = in.readLine().trim();
                if (token.equals("f")) {
                    System.out.print("Pattern: ");
                    token = in.readLine().trim();
                    System.out.println("Values: " + ht.findPattern(token));
                    continue;
                }
                if (token.equals("s")) {
                    System.out.print("Minimun value: ");
                    token = in.readLine().trim();
                    minCharCount = Integer.parseInt(token);
                    continue;
                }
                if (token.equals("l")) {
                    ht = new HyphenationTree();
                    System.out.print("XML file name: ");
                    token = in.readLine().trim();
                    ht.loadPatterns(token);
                    continue;
                }
                if (token.equals("L")) {
                    ois = null;
                    System.out.print("Object file name: ");
                    token = in.readLine().trim();
                    try {
                        try {
                            ois = new ObjectInputStream(new FileInputStream(token));
                            ht = (HyphenationTree)ois.readObject();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable var8_18) {
                        var7_12 = null;
                        if (ois == null) throw var8_18;
                        try {
                            ois.close();
                            throw var8_18;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var8_18;
                    }
                    {
                        var7_13 = null;
                        if (ois == null) continue;
                        try {}
                        catch (IOException e) {}
                        ois.close();
                    }
                    continue;
                }
                if (!token.equals("w")) break block32;
                System.out.print("Object file name: ");
                token = in.readLine().trim();
                oos = null;
                try {
                    try {
                        oos = new ObjectOutputStream(new FileOutputStream(token));
                        oos.writeObject(ht);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable var8_19) {
                    var7_14 = null;
                    if (oos == null) throw var8_19;
                    try {
                        oos.flush();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        oos.close();
                        throw var8_19;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var8_19;
                }
                {
                    block33: {
                        var7_15 = null;
                        if (oos == null) continue;
                        ** try [egrp 6[TRYBLOCK] [7 : 373->381)] { 
lbl83:
                        // 1 sources

                        oos.flush();
                        break block33;
lbl85:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    try {}
                    catch (IOException e) {}
                    oos.close();
                }
                continue;
            }
            if (token.equals("h")) {
                System.out.print("Word: ");
                token = in.readLine().trim();
                System.out.print("Hyphenation points: ");
                System.out.println(ht.hyphenate(token, minCharCount, minCharCount));
                continue;
            }
            if (token.equals("b")) {
                if (ht == null) {
                    System.out.println("No patterns has been loaded.");
                    return;
                }
                System.out.print("Word list filename: ");
                token = in.readLine().trim();
                starttime = 0L;
                counter = 0;
                try {
                    reader = new BufferedReader(new FileReader(token));
                    starttime = System.currentTimeMillis();
                    while ((line = reader.readLine()) != null) {
                        hyp = ht.hyphenate(line, minCharCount, minCharCount);
                        if (hyp != null) {
                            var11_25 = hyp.toString();
                        }
                        ++counter;
                    }
                }
                catch (Exception ioe) {
                    System.out.println("Exception " + ioe);
                    ioe.printStackTrace();
                }
                endtime = System.currentTimeMillis();
                result = endtime - starttime;
                System.out.println(String.valueOf(counter) + " words in " + result + " Millisekunden hyphenated");
                continue;
            }
            if (token.equals("q")) break;
        }
    }
}

