/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFTextPainter
implements TextPainter {
    FontState fontState;
    protected static final TextPainter PROXY_PAINTER = StrokingTextPainter.getInstance();

    public PDFTextPainter(FontState fs) {
        this.fontState = fs;
    }

    public void paint(TextNode node, Graphics2D g2d) {
        String txt = node.getText();
        Point2D loc = node.getLocation();
        TextNode.Anchor anchor = (TextNode.Anchor)node.getAttributedCharacterIterator().getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
        this.paintTextRuns(node.getTextRuns(), g2d, loc);
    }

    protected void paintTextRuns(List textRuns, Graphics2D g2d, Point2D loc) {
        Point2D currentloc = loc;
        Iterator i = textRuns.iterator();
        while (i.hasNext()) {
            StrokingTextPainter.TextRun run = (StrokingTextPainter.TextRun)i.next();
            currentloc = this.paintTextRun(run, g2d, currentloc);
        }
    }

    protected Point2D paintTextRun(StrokingTextPainter.TextRun run, Graphics2D g2d, Point2D loc) {
        AttributedCharacterIterator aci = run.getACI();
        return this.paintACI(aci, g2d, loc);
    }

    protected String getText(AttributedCharacterIterator aci) {
        StringBuffer sb = new StringBuffer(aci.getEndIndex() - aci.getBeginIndex());
        char c = aci.first();
        while (c != '\uffff') {
            sb.append(c);
            c = aci.next();
        }
        return sb.toString();
    }

    protected Point2D paintACI(AttributedCharacterIterator aci, Graphics2D g2d, Point2D loc) {
        aci.first();
        TextNode.Anchor anchor = (TextNode.Anchor)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
        Float xpos = (Float)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.X);
        Float ypos = (Float)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.Y);
        Float dxpos = (Float)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DX);
        Float dypos = (Float)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DY);
        if (xpos != null) {
            loc.setLocation(xpos.doubleValue(), loc.getY());
        }
        if (ypos != null) {
            loc.setLocation(loc.getX(), ypos.doubleValue());
        }
        if (dxpos != null) {
            loc.setLocation(loc.getX() + dxpos.doubleValue(), loc.getY());
        }
        if (dypos != null) {
            loc.setLocation(loc.getX(), loc.getY() + dypos.doubleValue());
        }
        List gvtFonts = (List)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
        Paint forg = (Paint)aci.getAttribute(TextAttribute.FOREGROUND);
        Float size = (Float)aci.getAttribute(TextAttribute.SIZE);
        if (size == null) {
            return loc;
        }
        Stroke stroke = (Stroke)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STROKE);
        Float posture = (Float)aci.getAttribute(TextAttribute.POSTURE);
        Float taWeight = (Float)aci.getAttribute(TextAttribute.WEIGHT);
        if (forg instanceof Color) {
            g2d.setColor((Color)forg);
        }
        g2d.setPaint(forg);
        g2d.setStroke(stroke);
        String style = posture != null && (double)posture.floatValue() > 0.0 ? "italic" : "normal";
        String weight = taWeight != null && (double)taWeight.floatValue() > 1.0 ? "bold" : "normal";
        FontInfo fi = this.fontState.getFontInfo();
        boolean found = false;
        if (gvtFonts != null) {
            Iterator i = gvtFonts.iterator();
            while (i.hasNext()) {
                GVTFontFamily fam = (GVTFontFamily)i.next();
                String name = fam.getFamilyName();
                if (!fi.hasFont(name, style, weight)) continue;
                try {
                    int fsize = (int)size.floatValue();
                    this.fontState = new FontState(this.fontState.getFontInfo(), name, style, weight, fsize * 1000, 0);
                }
                catch (FOPException fope) {
                    fope.printStackTrace();
                }
                found = true;
                break;
            }
        }
        if (!found) {
            try {
                int fsize = (int)size.floatValue();
                this.fontState = new FontState(this.fontState.getFontInfo(), "any", style, weight, fsize * 1000, 0);
            }
            catch (FOPException fope) {
                fope.printStackTrace();
            }
        } else if (g2d instanceof PDFGraphics2D) {
            ((PDFGraphics2D)((Object)g2d)).setOverrideFontState(this.fontState);
        }
        int fStyle = 0;
        fStyle = this.fontState.getFontWeight().equals("bold") ? (this.fontState.getFontStyle().equals("italic") ? 3 : 1) : (this.fontState.getFontStyle().equals("italic") ? 2 : 0);
        Font font = new Font(this.fontState.getFontFamily(), fStyle, this.fontState.getFontSize() / 1000);
        g2d.setFont(font);
        String txt = this.getText(aci);
        float advance = this.getStringWidth(txt);
        float tx = 0.0f;
        if (anchor != null) {
            switch (anchor.getType()) {
                case 1: {
                    tx = -advance / 2.0f;
                    break;
                }
                case 2: {
                    tx = -advance;
                }
            }
        }
        g2d.drawString(txt, (float)(loc.getX() + (double)tx), (float)loc.getY());
        loc.setLocation(loc.getX() + (double)advance, loc.getY());
        return loc;
    }

    private void printAttrs(AttributedCharacterIterator aci) {
        aci.first();
        Iterator<Map.Entry<AttributedCharacterIterator.Attribute, Object>> i = aci.getAttributes().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<AttributedCharacterIterator.Attribute, Object> entry = i.next();
            if (entry.getValue() == null) continue;
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
        int start = aci.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (aci.current() != '\uffff') {
            int end = aci.getRunLimit();
            System.out.print(end - start + ", ");
            aci.setIndex(end);
            if (start == end) break;
            start = end;
        }
        System.out.println("");
    }

    public float getStringWidth(String str) {
        float wordWidth = 0.0f;
        float whitespaceWidth = this.fontState.width(this.fontState.mapChar(' '));
        int i = 0;
        while (i < str.length()) {
            float charWidth;
            char c = str.charAt(i);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                charWidth = this.fontState.width(this.fontState.mapChar(c));
                if (charWidth <= 0.0f) {
                    charWidth = whitespaceWidth;
                }
            } else {
                charWidth = whitespaceWidth;
            }
            wordWidth += charWidth;
            ++i;
        }
        return wordWidth / 1000.0f;
    }

    public Mark getMark(TextNode node, int pos, boolean all) {
        System.out.println("PDFText getMark");
        return null;
    }

    public Mark selectAt(double x, double y, TextNode node) {
        System.out.println("PDFText selectAt");
        return null;
    }

    public Mark selectTo(double x, double y, Mark beginMark) {
        System.out.println("PDFText selectTo");
        return null;
    }

    public Mark selectAll(double x, double y, TextNode node) {
        System.out.println("PDFText selectAll");
        return null;
    }

    public Mark selectFirst(TextNode node) {
        System.out.println("PDFText selectFirst");
        return null;
    }

    public Mark selectLast(TextNode node) {
        System.out.println("PDFText selectLast");
        return null;
    }

    public int[] getSelected(Mark start, Mark finish) {
        System.out.println("PDFText getSelected");
        return null;
    }

    public Shape getHighlightShape(Mark beginMark, Mark endMark) {
        System.out.println("PDFText getHighlightShape");
        return null;
    }

    public Rectangle2D getBounds2D(TextNode node) {
        return PROXY_PAINTER.getBounds2D(node);
    }

    public Rectangle2D getGeometryBounds(TextNode node) {
        return PROXY_PAINTER.getGeometryBounds(node);
    }

    public Shape getOutline(TextNode node) {
        return PROXY_PAINTER.getOutline(node);
    }
}

