/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.viewer.LoadableProperties;
import org.apache.fop.viewer.Translator;

public class SecureResourceBundle
extends ResourceBundle
implements Translator {
    private boolean isMissingEmphasized = false;
    private LoadableProperties lookup = new LoadableProperties();
    private boolean isSourceFound = true;

    public void setMissingEmphasized(boolean flag) {
        this.isMissingEmphasized = flag;
    }

    public SecureResourceBundle(InputStream in) {
        try {
            this.lookup.load(in);
        }
        catch (Exception ex) {
            MessageHandler.logln("Exception catched: " + ex.getMessage());
            this.isSourceFound = false;
        }
    }

    public Enumeration getKeys() {
        return this.lookup.keys();
    }

    public Object handleGetObject(String key) {
        if (key == null) {
            return "Key is null";
        }
        Object obj = this.lookup.get(key);
        if (obj != null) {
            return obj;
        }
        if (this.isMissingEmphasized) {
            MessageHandler.logln(String.valueOf(this.getClass().getName()) + ": missing key: " + key);
            return this.getMissedRepresentation(key.toString());
        }
        return key.toString();
    }

    public boolean contains(String key) {
        return key != null && this.lookup.get(key) != null;
    }

    private String getMissedRepresentation(String str) {
        return "<!" + str + "!>";
    }

    public boolean isSourceFound() {
        return this.isSourceFound;
    }
}

