/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.modules;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.panel.ContentTextPanel;
import net.sf.sqs_xml.editor.base.modules.resource.EditorResource;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentTextEditor
extends AbstractNodeEditor {
    public static final long serialVersionUID = 0L;
    ContentTextEditor[] contentTextEditor;
    ContentTextPanel panel;

    public ContentTextEditor(SourceEditorMediator mediator, DOMTreeSource source, Node node, EditorResource resource) {
        super(mediator, source, node, resource);
        if (node.getNodeType() == 3) {
            this.panel = new ContentTextPanel(this, node);
            this.add(this.panel);
            this.prefHeight += this.panel.getPreferredHeight();
        } else {
            NodeList list = node.getChildNodes();
            this.contentTextEditor = new ContentTextEditor[list.getLength()];
            this.setLayout(new BoxLayout(this, 1));
            int i = 0;
            while (i < list.getLength()) {
                Node item = list.item(i);
                EditorResource subResource = mediator.getEditorResourceFactory().getEditorResource(item);
                this.contentTextEditor[i] = new ContentTextEditor(mediator, source, item, subResource);
                this.contentTextEditor[i].setPreferredSize(new Dimension(200, this.contentTextEditor[i].getHeight()));
                this.contentTextEditor[i].setSize(new Dimension(200, this.contentTextEditor[i].getHeight()));
                this.prefHeight += this.contentTextEditor[i].getPreferredHeight();
                this.add(this.contentTextEditor[i]);
                ++i;
            }
        }
        this.initSize();
    }

    public boolean updateNodeValue() {
        if (this.node.getNodeType() == 3) {
            if (this.panel.updateNodeValue()) {
                super.updateNodeValue();
                return true;
            }
            return false;
        }
        boolean isUpdated = false;
        int i = 0;
        while (i < this.contentTextEditor.length) {
            if (this.contentTextEditor[i].updateNodeValue()) {
                isUpdated = true;
            }
            ++i;
        }
        if (isUpdated) {
            super.updateNodeValue();
            return true;
        }
        return false;
    }
}

