/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.modules.panel;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractNodeEditorPanel;
import net.sf.sqs_xml.swing.EditMenuTextArea;
import net.sf.sqs_xml.util.DOMUtil;
import org.w3c.dom.Node;

public abstract class AbstractSingleNodeEditorPanel
extends AbstractNodeEditorPanel {
    EditMenuTextArea nodeValueTextArea = new EditMenuTextArea(3, 30);
    JComponent nodeValueEditor = this.createNodeValueEditor(this.nodeValueTextArea);
    String previousValue = null;
    UndoManager undoManager = null;

    public AbstractSingleNodeEditorPanel(AbstractNodeEditor editor) {
        super(editor);
        this.initNodeValueEditor(editor);
        this.add(this.nodeValueEditor);
        this.initSize();
    }

    private void initNodeValueEditor(AbstractNodeEditor editor) {
        if (editor.getNode() != null) {
            try {
                Node node = editor.getNode();
                this.previousValue = DOMUtil.stringValueOf(editor.getSource().getDocument(), node, this.getDescriptionXPath());
                Document document = editor.getDocument();
                this.undoManager = editor.getUndoManager();
                if (document == null) {
                    this.undoManager = new UndoManager();
                    this.nodeValueTextArea.setText(this.previousValue);
                    document = this.nodeValueTextArea.getDocument();
                    editor.setUndoManager(this.undoManager);
                    editor.setDocument(document);
                    this.nodeValueTextArea.setUndoManager(this.undoManager);
                } else {
                    this.nodeValueTextArea.setDocument(document);
                    this.nodeValueTextArea.setUndoManager(this.undoManager);
                }
                if (editor.getSource().isReadOnly()) {
                    this.nodeValueTextArea.setEnabled(false);
                }
            }
            catch (ClassCastException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public JComponent createNodeValueEditor(JTextArea nodeValueTextArea) {
        Box nodeValueEditor = Box.createHorizontalBox();
        nodeValueEditor.add(new JScrollPane(nodeValueTextArea));
        nodeValueTextArea.addFocusListener(this.editor.getUpdateListener());
        return nodeValueEditor;
    }

    public abstract String getDescriptionXPath();

    public String getDescriptionLabel() {
        return "";
    }

    public boolean updateNodeValue() {
        if (this.previousValue == null || !this.previousValue.equals(this.nodeValueTextArea.getText())) {
            this.editor.updateNodeValue(this.getDescriptionXPath(), this.nodeValueTextArea.getText());
            return true;
        }
        return false;
    }
}

