/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.source;

import java.util.LinkedList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class DOMTreeWalkerTreeModel
implements TreeModel {
    TreeWalker walker;
    LinkedList listenerList = new LinkedList();

    public DOMTreeWalkerTreeModel(TreeWalker walker) {
        this.walker = walker;
    }

    public DOMTreeWalkerTreeModel(Document document) {
        DocumentTraversal dt = (DocumentTraversal)((Object)document);
        this.walker = dt.createTreeWalker(document, -1, null, false);
    }

    public DOMTreeWalkerTreeModel(Element element) {
        DocumentTraversal dt = (DocumentTraversal)((Object)element.getOwnerDocument());
        this.walker = dt.createTreeWalker(element, -1, null, false);
    }

    public Object getRoot() {
        return this.walker.getRoot();
    }

    public boolean isLeaf(Object node) {
        this.walker.setCurrentNode((Node)node);
        Node child = this.walker.firstChild();
        return child == null;
    }

    public int getChildCount(Object node) {
        this.walker.setCurrentNode((Node)node);
        int numkids = 0;
        Node child = this.walker.firstChild();
        while (child != null) {
            ++numkids;
            child = this.walker.nextSibling();
        }
        return numkids;
    }

    public Object getChild(Object parent, int index) {
        this.walker.setCurrentNode((Node)parent);
        Node child = this.walker.firstChild();
        while (index-- > 0) {
            child = this.walker.nextSibling();
        }
        return child;
    }

    public int getIndexOfChild(Object parent, Object child) {
        this.walker.setCurrentNode((Node)parent);
        int index = 0;
        Node c = this.walker.firstChild();
        while (c != child && c != null) {
            ++index;
            c = this.walker.nextSibling();
        }
        return index;
    }

    public int _getIndexOfChild(Object parent, Object child) {
        this.walker.setCurrentNode((Node)parent);
        int index = 0;
        Node c = this.walker.firstChild();
        while (c != child && c != null) {
            ++index;
            c = this.walker.nextSibling();
        }
        if (c == null) {
            return -1 * index;
        }
        return index;
    }

    public void valueForPathChanged(TreePath path, Object value) {
        int i = 0;
        while (i < this.listenerList.size()) {
            ((TreeModelListener)this.listenerList.get(i)).treeStructureChanged(new TreeModelEvent((Object)this, path));
            ++i;
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(l);
    }
}

