/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.source;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import net.sf.sqs_xml.editor.base.source.SourceException;

public abstract class Source {
    String title = null;
    File file = null;
    URL url = null;
    long mtime = 0L;
    boolean dirty = false;
    boolean readonly = false;
    static int serial = 1;

    public Source() throws SourceException {
        this.title = "*Undefined" + serial++;
        this.file = null;
        this.dirty = false;
        this.readonly = false;
    }

    public Source(File file) throws SourceException {
        this.title = null;
        this.file = file;
        this.mtime = file.lastModified();
        this.readonly = !file.canWrite();
        this.dirty = false;
        try {
            this.initialize(new FileInputStream(file));
        }
        catch (IOException ex) {
            throw new SourceException(ex);
        }
    }

    public Source(URL url, boolean readonly, String title) throws SourceException {
        String readOnlyMark;
        this.url = url;
        String string = readOnlyMark = readonly ? "%" : "";
        if (title != null) {
            this.title = String.valueOf(readOnlyMark) + title;
        } else {
            String filePart = url.getFile();
            try {
                String file = filePart.substring(filePart.lastIndexOf(47) + 1);
                this.title = String.valueOf(readOnlyMark) + file;
            }
            catch (NullPointerException ex) {
                this.title = String.valueOf(readOnlyMark) + filePart;
            }
        }
        if (url.getProtocol().toLowerCase().equals(this.file)) {
            this.setFile(new File(url.getFile()));
        } else {
            this.file = null;
        }
        this.readonly = readonly;
        this.dirty = false;
        try {
            this.initialize(url.openStream());
        }
        catch (IOException ex) {
            throw new SourceException(ex);
        }
    }

    public String toString() {
        return "Source[" + this.title + " " + this.file + "(" + this.url + ")]";
    }

    public abstract void initialize(InputStream var1) throws SourceException;

    public abstract InputStream createInputStream() throws IOException;

    public void update() {
        this.mtime = this.file.lastModified();
    }

    public long lastModified() {
        return this.mtime;
    }

    public boolean isModified() {
        if (this.file != null) {
            return this.mtime < this.file.lastModified();
        }
        return false;
    }

    public void setFile(File file) {
        this.file = file;
        if (file != null) {
            this.readonly = !file.canWrite();
        }
    }

    public boolean equals(Object obj) {
        try {
            Source source = (Source)obj;
            if (source == null || source.getFile() == null || this.getFile() == null) {
                return false;
            }
            return source.getFile().getAbsoluteFile().equals(this.getFile().getAbsoluteFile());
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public File getFile() {
        return this.file;
    }

    public URL getURL() {
        return this.url;
    }

    public String getTitle() {
        String prefix = "";
        if (this.readonly) {
            prefix = "%";
        } else if (this.dirty) {
            prefix = "*";
        }
        if (this.file != null) {
            return String.valueOf(prefix) + this.file.getName();
        }
        return String.valueOf(prefix) + this.title;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.createInputStream();
            out = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            byte[] buf = new byte[4096];
            while (true) {
                int len;
                block7: {
                    if ((len = in.read(buf, 0, 1024)) > 0) break block7;
                    this.setDirty(false);
                    break;
                }
                out.write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                out.close();
                in.close();
                this.update();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        out.close();
        in.close();
        this.update();
    }
}

