/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.metal.MetalIconFactory;
import net.sf.sqs_xml.editor.base.swing.SuffixBasedFileChooser;
import net.sf.sqs_xml.swing.IconFactory;
import net.sf.sqs_xml.swing.SuffixBasedFileFilter;
import net.sf.sqs_xml.swing.SwingUtil;

public class SQSFileChooser
extends SuffixBasedFileChooser {
    public static final long serialVersionUID = 0L;
    public static final String DEFAULT_FILENAME = "newfile";
    public static final String OPEN_SQSSOURCE_TITLE = "SQS Source\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f";
    public static final String SAVE_SQSSOURCE_TITLE = "SQS Source\u30d5\u30a1\u30a4\u30eb\u306e\u5225\u5f62\u5f0f\u3067\u306e\u66f8\u304d\u51fa\u3057";
    public static final String SAVE_SQSMASTER_TITLE = "SQS Master\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3059\u308b";
    public static final String SAVE_PDFMARKSHEET_TITLE = "PDF File\u3092\u4fdd\u5b58\u3059\u308b";
    public static final String OPEN_SQSFOLDER_TITLE = "\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304f";
    public static final String SAVE_RESULTFOLDER_TITLE = "\u30d5\u30a9\u30eb\u30c0\u306b\u4fdd\u5b58\u3059\u308b";
    public static final String SQSSOURCE_DESCRIPTION = "\u8abf\u67fb\u7968\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb SQS Source(.sqs)";
    public static final String SQSFOLDER_DESCRIPTION = "\u30d5\u30a9\u30eb\u30c0(\u30b9\u30ad\u30e3\u30f3\u753b\u50cf\u3068\u5370\u5237\u539f\u7a3fPDF\u30d5\u30a1\u30a4\u30eb\u3092\u542b\u3080\u3082\u306e)";
    public static final String SQSMASTER_DESCRIPTION = "SQS Master\u30d5\u30a1\u30a4\u30eb(.sqm)";
    public static final String HTMLFORM_DESCRIPTION = "Web\u30d6\u30e9\u30a6\u30b6\u4e0a\u3067\u306e\u56de\u7b54\u306e\u305f\u3081\u306eHTML\u30d5\u30a9\u30fc\u30e0 (.html)";
    public static final String PDFMARKSHEET_DESCRIPTION = "\u30de\u30fc\u30af\u30b7\u30fc\u30c8\u5f0f\u306e\u8abf\u67fb\u7968\u5370\u5237\u539f\u7a3f\u306ePDF (.pdf)";
    public static final String RESULTFOLDER_DESCRIPTION = "\u30d5\u30a9\u30eb\u30c0(\u96c6\u8a08\u7d50\u679c\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58)";
    static Icon sqsIcon;
    static Icon pdfIcon;
    static Icon textImageIcon;
    static Icon srcImageIcon;
    static Icon treeFolderIcon;
    static Icon defaultFileIcon;
    static Icon csvIcon;
    String defaultSuffix;
    String baseuri;
    static final Object[][] SUFFIX_ICON_MAP;

    static {
        SUFFIX_ICON_MAP = new Object[][]{{".tiff", srcImageIcon}, {".jpg", srcImageIcon}, {".jpeg", srcImageIcon}, {".gif", srcImageIcon}, {".png", textImageIcon}, {".sqs", sqsIcon}, {".pdf", pdfIcon}, {"-csv.txt", csvIcon}};
    }

    public SQSFileChooser(SuffixBasedFileFilter filter) {
        super(filter);
        if (sqsIcon == null) {
            pdfIcon = IconFactory.create("pdfdoc.gif");
            sqsIcon = IconFactory.create("sqs-tiny.gif");
            textImageIcon = IconFactory.create("image1.gif");
            srcImageIcon = IconFactory.create("image2.gif");
            csvIcon = IconFactory.create("csv.gif");
            treeFolderIcon = new MetalIconFactory.TreeFolderIcon();
            defaultFileIcon = new MetalIconFactory.TreeLeafIcon();
        }
    }

    public String getSuffix() {
        return ((SuffixBasedFileFilter)this.getFileFilter()).getSuffix();
    }

    public static JFileChooser createExportFileChooser() {
        SuffixBasedFileFilter pdfFilter = SwingUtil.createSuffixBasedFileFilter(".pdf", PDFMARKSHEET_DESCRIPTION);
        SuffixBasedFileFilter htmlFilter = SwingUtil.createSuffixBasedFileFilter(".html", HTMLFORM_DESCRIPTION);
        SQSFileChooser exportFileChooser = new SQSFileChooser(pdfFilter);
        exportFileChooser.setDialogTitle(SAVE_SQSSOURCE_TITLE);
        exportFileChooser.addChoosableFileFilter(htmlFilter);
        exportFileChooser.addChoosableFileFilter(pdfFilter);
        return exportFileChooser;
    }

    private static SuffixBasedFileChooser createFileChooser(String title, String suffix, String description, File selectedFile) {
        SuffixBasedFileFilter filter = SwingUtil.createSuffixBasedFileFilter(suffix, description);
        SQSFileChooser chooser = new SQSFileChooser(filter);
        chooser.setDialogTitle(title);
        if (selectedFile != null) {
            if (selectedFile.isDirectory()) {
                chooser.setSelectedFile(selectedFile.getParentFile());
            } else {
                chooser.setCurrentDirectory(selectedFile.getParentFile());
                chooser.setSelectedFile(selectedFile);
            }
        } else if (suffix != null) {
            chooser.setSelectedFile(new File(String.valueOf(chooser.getCurrentDirectory().getAbsolutePath()) + File.separator + DEFAULT_FILENAME + suffix));
        }
        return chooser;
    }

    public static SuffixBasedFileChooser createOpenSQSSourceChooser(File selectedFile) {
        return SQSFileChooser.createFileChooser(OPEN_SQSSOURCE_TITLE, ".sqs", SQSSOURCE_DESCRIPTION, selectedFile);
    }

    public static SuffixBasedFileChooser createSaveSQSFileChooser(File selectedFile) {
        return SQSFileChooser.createFileChooser(SAVE_SQSSOURCE_TITLE, ".sqs", SQSSOURCE_DESCRIPTION, selectedFile);
    }

    public static SuffixBasedFileChooser createSavePDFFileChooser(File selectedFile) {
        return SQSFileChooser.createFileChooser(SAVE_PDFMARKSHEET_TITLE, ".pdf", PDFMARKSHEET_DESCRIPTION, selectedFile);
    }

    public static SuffixBasedFileChooser createSaveSQMFileChooser(File selectedFile) {
        return SQSFileChooser.createFileChooser(SAVE_SQSMASTER_TITLE, ".sqm", SQSMASTER_DESCRIPTION, selectedFile);
    }

    public static SuffixBasedFileChooser createSaveReaderResultFolderChooser(File dir) {
        SuffixBasedFileFilter folderFilter = SwingUtil.createSuffixBasedFileFilter(null, RESULTFOLDER_DESCRIPTION);
        SQSFileChooser sqsFolderChooser = new SQSFileChooser(null);
        sqsFolderChooser.setFileSelectionMode(2);
        if (dir != null) {
            sqsFolderChooser.setCurrentDirectory(dir);
        }
        sqsFolderChooser.setDialogTitle(OPEN_SQSFOLDER_TITLE);
        sqsFolderChooser.addChoosableFileFilter(folderFilter);
        return sqsFolderChooser;
    }

    public static SuffixBasedFileChooser createOpenSQSFolderChooser(File dir) {
        SuffixBasedFileFilter folderFilter = SwingUtil.createSuffixBasedFileFilter(null, SQSFOLDER_DESCRIPTION);
        SQSFileChooser sqsFolderChooser = new SQSFileChooser(null);
        sqsFolderChooser.setFileSelectionMode(2);
        if (dir != null) {
            sqsFolderChooser.setCurrentDirectory(dir);
        }
        sqsFolderChooser.setDialogTitle(OPEN_SQSFOLDER_TITLE);
        sqsFolderChooser.addChoosableFileFilter(folderFilter);
        return sqsFolderChooser;
    }

    public FileView createFileView() {
        return new SQSFileView();
    }

    class SQSFileView
    extends FileView {
        SQSFileView() {
        }

        public Icon getIcon(File f) {
            String name = f.getName();
            if (f.isDirectory()) {
                return treeFolderIcon;
            }
            int i = 0;
            while (i < SUFFIX_ICON_MAP.length) {
                Object[] entry = SUFFIX_ICON_MAP[i];
                String suffix = (String)entry[0];
                if (name.endsWith(suffix)) {
                    return (Icon)entry[1];
                }
                ++i;
            }
            return defaultFileIcon;
        }
    }
}

