/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.sqs_xml.editor.base.swing.SourceEditorToolBar;
import net.sf.sqs_xml.editor.sqs.swing.ExportFileLogic;
import net.sf.sqs_xml.editor.sqs.swing.SQSSourceEditorMediator;
import net.sf.sqs_xml.swing.IconFactory;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.util.AlbertBrowserLauncher;
import net.sf.sqs_xml.util.BrowserLauncher;
import net.sf.sqs_xml.util.JNLPBrowserLauncher;

public class SQSSourceEditorToolBar
extends SourceEditorToolBar {
    public static final long serialVersionUID = 0L;
    private SQSSourceEditorMediator mediator;
    JButton htmlExportButton;
    JButton previewExportButton;
    JButton pdfExportButton;
    JButton closeButton;
    final ExportFileLogic logic;

    public SQSSourceEditorToolBar(final SQSSourceEditorMediator mediator) {
        this.mediator = mediator;
        this.logic = new ExportFileLogic(mediator);
        this.setPreferredSize(new Dimension(660, 24));
        this.htmlExportButton = new JButton("HTML\u30d5\u30a9\u30fc\u30e0", IconFactory.create("formdoc.gif", "HTML\u66f8\u304d\u51fa\u3057"));
        this.htmlExportButton.setPreferredSize(new Dimension(195, 20));
        this.previewExportButton = new JButton("HTML\u3067\u5370\u5237\u539f\u7a3f\u3092\u30d7\u30ec\u30d3\u30e5\u30fc", IconFactory.create("preview.gif", "HTML\u66f8\u304d\u51fa\u3057"));
        this.previewExportButton.setPreferredSize(new Dimension(220, 20));
        this.pdfExportButton = new JButton("PDF\u3067\u5370\u5237\u539f\u7a3f\u3092\u30d7\u30ec\u30d3\u30e5\u30fc", IconFactory.create("pdfdoc.gif", "PDF\u66f8\u304d\u51fa\u3057"));
        this.pdfExportButton.setPreferredSize(new Dimension(190, 20));
        this.closeButton = new JButton(MetalIconFactory.getInternalFrameCloseIcon(18));
        this.closeButton.setPreferredSize(new Dimension(19, 20));
        this.closeButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.htmlExportButton.setToolTipText("Web\u30d6\u30e9\u30a6\u30b6\u3067\u56de\u7b54\u3059\u308b\u305f\u3081\u306e\u30d5\u30a9\u30fc\u30e0\u3092\u751f\u6210\u3057\u307e\u3059");
        this.previewExportButton.setToolTipText("HTML\u3067\u30ec\u30a4\u30a2\u30a6\u30c8\u3092\u78ba\u8a8d\u3057\u307e\u3059");
        this.pdfExportButton.setToolTipText("PDF\u5f62\u5f0f\u3067\u5370\u5237\u539f\u7a3f\u3092\u78ba\u8a8d\u3057\u307e\u3059");
        this.closeButton.setToolTipText("\u3053\u306e\u30d0\u30c3\u30d5\u30a1\u3092\u9589\u3058\u307e\u3059");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                mediator.getMenuBarMediator().close();
            }
        });
        this.setupBrowserLauncher();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        Box left = Box.createHorizontalBox();
        left.add(Box.createHorizontalStrut(7));
        left.add(this.htmlExportButton);
        left.add(Box.createHorizontalStrut(7));
        left.add(this.previewExportButton);
        left.add(Box.createHorizontalStrut(7));
        left.add(this.pdfExportButton);
        panel.add((Component)left, "West");
        panel.add((Component)this.closeButton, "East");
        this.add(panel);
        this.setEnabled(false);
    }

    public void setupBrowserLauncher() {
        block5: {
            if (this.isBasicServiceEnabled()) {
                try {
                    BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                    if (basicService.isWebBrowserSupported()) {
                        this.setupButtonActionListener(new JNLPBrowserLauncher(basicService));
                        break block5;
                    }
                    this.setupButtonActionListener(new AlbertBrowserLauncher());
                }
                catch (UnavailableServiceException ignore) {
                    this.setupButtonActionListener(new AlbertBrowserLauncher());
                }
            } else {
                this.setupButtonActionListener(new AlbertBrowserLauncher());
            }
        }
    }

    public boolean isBasicServiceEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.htmlExportButton.setEnabled(enabled);
        this.previewExportButton.setEnabled(enabled);
        this.pdfExportButton.setEnabled(enabled);
        this.closeButton.setVisible(enabled);
    }

    private void setupButtonActionListener(final BrowserLauncher launcher) {
        this.htmlExportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    SQSSourceEditorToolBar.this.logic.export(launcher, 0);
                }
                catch (IOException e) {
                    SQSSourceEditorToolBar.this.mediator.getMenuBarMediator().showError(e, "\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
                catch (TransformerFactoryConfigurationError e) {
                    e.printStackTrace();
                }
                catch (TranslatorException e) {
                    SQSSourceEditorToolBar.this.mediator.getMenuBarMediator().showError(e, "\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
            }
        });
        this.previewExportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    SQSSourceEditorToolBar.this.logic.export(launcher, 1);
                }
                catch (IOException e) {
                    SQSSourceEditorToolBar.this.mediator.getMenuBarMediator().showError(e, "\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
                catch (TransformerFactoryConfigurationError e) {
                    e.printStackTrace();
                }
                catch (TranslatorException e) {
                    SQSSourceEditorToolBar.this.mediator.getMenuBarMediator().showError(e, "\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
            }
        });
        this.pdfExportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    SQSSourceEditorToolBar.this.logic.export(launcher, 2);
                }
                catch (IOException e) {
                    SQSSourceEditorToolBar.this.mediator.getMenuBarMediator().showError(e, "\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
                catch (TransformerFactoryConfigurationError e) {
                    e.printStackTrace();
                }
                catch (TranslatorException e) {
                    SQSSourceEditorToolBar.this.mediator.getMenuBarMediator().showError(e, "\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
            }
        });
    }
}

