/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.httpd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.sqs_xml.httpd.MicroHttpd;
import net.sf.sqs_xml.httpd.SQSHttpdFactory;
import net.sf.sqs_xml.httpd.ViewMatrixServlet;
import net.sf.sqs_xml.util.DOMUtil;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.StringUtil;
import net.sf.sqs_xml.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateMatrixServlet
extends ViewMatrixServlet {
    public static final long serialVersionUID = 0L;

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            request.setCharacterEncoding("UTF-8");
            String resultDir = this.getResultDir(request);
            String srcfile = request.getParameter("src");
            MicroHttpd httpd = SQSHttpdFactory.getInitialHttpd();
            List matrix = this.readCSV(new File(resultDir), "MS932");
            this.update(request, matrix);
            this.updateHTML(new File(resultDir), request, matrix, "UTF-8");
            this.writeCSV(new File(resultDir), matrix, "MS932");
            response.sendRedirect(String.valueOf(httpd.getBase()) + "servlet/ViewMatrix?dir=" + URLEncoder.encode(resultDir, "UTF-8") + "&src=" + srcfile);
        }
        catch (SAXException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private void update(HttpServletRequest request, List matrix) throws IOException {
        int rowIndex = 1;
        while (rowIndex < matrix.size()) {
            List column = (List)matrix.get(rowIndex);
            int colIndex = 2;
            while (colIndex < column.size()) {
                String value = request.getParameter(String.valueOf(colIndex) + "-" + rowIndex);
                if (value != null) {
                    column.set(colIndex, value);
                }
                ++colIndex;
            }
            ++rowIndex;
        }
    }

    void writeCSV(File resultDir, List matrix, String encoding) throws IOException {
        File csvFile = this.getCSVFile(resultDir);
        PrintWriter writer = FileUtil.createPrintWriter(csvFile, encoding);
        int rowIndex = 0;
        while (rowIndex < matrix.size()) {
            List column = (List)matrix.get(rowIndex);
            int colIndex = 0;
            while (colIndex < column.size()) {
                if (colIndex != 0) {
                    writer.print("\t");
                }
                String arg = (String)column.get(colIndex);
                writer.print(StringUtil.escape(arg));
                ++colIndex;
            }
            writer.println();
            ++rowIndex;
        }
        writer.close();
    }

    File getMarkFile(File resultDir) {
        return this.findFile(resultDir, "mark.html");
    }

    void updateHTML(File resultDir, HttpServletRequest request, List matrix, String encoding) throws IOException, SAXException, ParserConfigurationException {
        File markFile = this.getMarkFile(resultDir);
        Document document = XMLUtil.createParser().parse(markFile);
        document.normalize();
        Element tbodyElem = DOMUtil.getElement(document.getDocumentElement(), new String[][]{{"http://www.w3.org/1999/xhtml", "body"}, {"http://www.w3.org/1999/xhtml", "table"}, {"http://www.w3.org/1999/xhtml", "tbody"}});
        NodeList trList = tbodyElem.getElementsByTagNameNS("http://www.w3.org/1999/xhtml", "tr");
        int rowIndex = 1;
        while (rowIndex < matrix.size()) {
            List column = (List)matrix.get(rowIndex);
            NodeList tdList = ((Element)trList.item(rowIndex - 1)).getElementsByTagNameNS("http://www.w3.org/1999/xhtml", "td");
            int colIndex = 2;
            while (colIndex < column.size()) {
                String value = request.getParameter(String.valueOf(colIndex) + "-" + rowIndex);
                if (value != null && !"?".equals(value)) {
                    Element tdElem = (Element)tdList.item(colIndex - 2);
                    NodeList children = tdElem.getChildNodes();
                    int i = 0;
                    while (i < children.getLength()) {
                        tdElem.removeChild(children.item(i));
                        ++i;
                    }
                    Element preElem = document.createElementNS("http://www.w3.org/1999/xhtml", "pre");
                    preElem.appendChild(document.createTextNode(value));
                    tdElem.appendChild(preElem);
                }
                ++colIndex;
            }
            ++rowIndex;
        }
        FileOutputStream output = new FileOutputStream(markFile);
        XMLUtil.marshal(document, output);
        output.close();
    }
}

