/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.model;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sf.sqs_xml.reader.model.FormElementsMarkarea;
import net.sf.sqs_xml.reader.model.FormElementsTextarea;
import net.sf.sqs_xml.reader.model.IFormElementsChoice;
import net.sf.sqs_xml.reader.model.IRNSContainer;
import net.sf.sqs_xml.reader.model.IRNode;
import net.sf.sqs_xml.reader.model.RNSContext;
import net.sf.sqs_xml.reader.model.RStack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FormElements
implements Serializable,
Cloneable,
IRNSContainer,
IRNode {
    public static final long serialVersionUID = 0L;
    private RNSContext rNSContext_ = new RNSContext(this, "");
    private List content_ = new ArrayList();
    private IRNode parentRNode_;

    public FormElements() {
    }

    public FormElements(FormElements source) {
        this.setup(source);
    }

    public FormElements(RStack stack) {
        this.setup(stack);
    }

    public void setup(FormElements source) {
        this.content_.clear();
        int size = source.content_.size();
        int i = 0;
        while (i < size) {
            this.addContent((IFormElementsChoice)source.getContent(i).clone());
            ++i;
        }
    }

    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        this.content_.clear();
        while (true) {
            if (FormElementsMarkarea.isMatch(stack)) {
                this.addContent(new FormElementsMarkarea(stack));
                continue;
            }
            if (!FormElementsTextarea.isMatch(stack)) break;
            this.addContent(new FormElementsTextarea(stack));
        }
    }

    public Object clone() {
        return new FormElements(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeElement(element);
            ++i;
        }
    }

    public RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public IFormElementsChoice[] getContent() {
        IFormElementsChoice[] array = new IFormElementsChoice[this.content_.size()];
        return this.content_.toArray(array);
    }

    public void setContent(IFormElementsChoice[] content) {
        this.content_.clear();
        int i = 0;
        while (i < content.length) {
            this.addContent(content[i]);
            ++i;
        }
        i = 0;
        while (i < content.length) {
            content[i].rSetParentRNode(this);
            ++i;
        }
    }

    public void setContent(IFormElementsChoice content) {
        this.content_.clear();
        this.addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public void addContent(IFormElementsChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public void addContent(IFormElementsChoice[] content) {
        int i = 0;
        while (i < content.length) {
            this.addContent(content[i]);
            ++i;
        }
        i = 0;
        while (i < content.length) {
            content[i].rSetParentRNode(this);
            ++i;
        }
    }

    public int sizeContent() {
        return this.content_.size();
    }

    public IFormElementsChoice getContent(int index) {
        return (IFormElementsChoice)this.content_.get(index);
    }

    public void setContent(int index, IFormElementsChoice content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public void addContent(int index, IFormElementsChoice content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public void removeContent(int index) {
        this.content_.remove(index);
    }

    public void removeContent(IFormElementsChoice content) {
        this.content_.remove(content);
    }

    public void clearContent() {
        this.content_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("");
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
    }

    public void makeTextElement(Writer buffer) throws IOException {
        String prefix = this.rNSContext_.getPrefixByUri("");
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
    }

    public void makeTextElement(PrintWriter buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("");
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
    }

    public void makeTextAttribute(StringBuffer buffer) {
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
    }

    public void makeTextAttribute(PrintWriter buffer) {
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(RStack stack) {
        return FormElements.isMatchHungry(stack.makeClone());
    }

    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack;
        boolean $match$ = false;
        Element element = stack.peekElement();
        while (true) {
            if (FormElementsMarkarea.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!FormElementsTextarea.isMatchHungry(target)) break;
            $match$ = true;
        }
        return $match$;
    }
}

