/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.receiver;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.sqs_xml.util.StringUtil;

public class ReceiverServlet
extends HttpServlet {
    public static final long serialVersionUID = 0L;
    public static final File DATA_LOG_FILE = new File("/var/tmp/sqs-log");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map parameterMap = request.getParameterMap();
        Object[] keyArray = parameterMap.keySet().toArray();
        Arrays.sort(keyArray);
        response.setContentType("text/plain; charset=UTF-8");
        File file = DATA_LOG_FILE;
        synchronized (file) {
            PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(DATA_LOG_FILE, true)), "UTF-8"));
            if (DATA_LOG_FILE.length() == 0L) {
                this.printHeader(keyArray, logWriter);
            }
            this.printLine(parameterMap, keyArray, logWriter);
            logWriter.flush();
            logWriter.close();
        }
        PrintWriter writer = new PrintWriter(response.getWriter());
        writer.println("\u3054\u5354\u529b\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3057\u305f\uff0e");
        writer.close();
    }

    private void printLine(Map parameterMap, Object[] keyArray, PrintWriter logWriter) {
        logWriter.print(String.valueOf(DATE_FORMAT.format(new Date())) + "\t");
        int i = 0;
        while (i < keyArray.length) {
            String key = (String)keyArray[i];
            String[] values = (String[])parameterMap.get(key);
            String value = null;
            try {
                value = new String(values[0].getBytes("iso-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            logWriter.print("\t");
            logWriter.print(key);
            logWriter.print("=");
            logWriter.print(StringUtil.escape(value));
            ++i;
        }
        logWriter.println();
    }

    private void printHeader(Object[] keyArray, PrintWriter logWriter) {
        logWriter.print("*");
        int i = 0;
        while (i < keyArray.length) {
            logWriter.print("\t");
            logWriter.print(keyArray[i]);
            ++i;
        }
        logWriter.println();
    }
}

