/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.translator.servlet;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import net.sf.sqs_xml.translator.logic.SQStoPDFTranslator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;
import net.sf.sqs_xml.translator.servlet.GenericTranslationServlet;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;

public class SQStoPDFServlet
extends GenericTranslationServlet {
    public static final long serialVersionUID = 0L;
    SQStoPDFTranslator logic = new SQStoPDFTranslator();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void perform(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, TransformerException {
        try {
            String fileNameBody = (String)req.getAttribute("fileNameBody");
            InputStream sqsInputStream = (InputStream)req.getAttribute("fileInputStream");
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            this.logic.translate(sqsInputStream, new TranslatorResource((Logger)new NullLogger()), out, null);
            res.setContentLength(out.size());
            res.setContentType("application/pdf");
            res.setHeader("Content-Disposition:", "attachment; filename=" + fileNameBody + ".pdf");
            out.writeTo((OutputStream)res.getOutputStream());
            out.flush();
            out.close();
            res.getOutputStream().flush();
            res.getOutputStream().close();
        }
        catch (FileNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (TranslatorException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

