/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.translator.swing;

import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sf.sqs_xml.editor.sqs.swing.SQSFileChooser;
import net.sf.sqs_xml.httpd.SourceEditorHttpd;
import net.sf.sqs_xml.swing.SwingUtil;
import net.sf.sqs_xml.translator.logic.SQStoPDFTranslator;
import net.sf.sqs_xml.translator.logic.Translator;
import net.sf.sqs_xml.translator.swing.SQSFileTranslator;

public class PDFMaker
extends SQSFileTranslator {
    public static final long serialVersionUID = 0L;
    static final String TITLE = "SQS PDF Maker";

    public static void main(String[] args) throws Exception {
        try {
            SourceEditorHttpd.getSingleton();
        }
        catch (Error error) {
            // empty catch block
        }
        System.setProperty("swing.plaf.metal.controlFont", "Monospaced-12");
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        SwingUtil.Factory factory = new SwingUtil.Factory(){

            public Object create() throws Exception {
                return new SQStoPDFTranslator();
            }
        };
        SQStoPDFTranslator translator = (SQStoPDFTranslator)SwingUtil.newInstanceWithWaitPromptFrame(factory, TITLE, "Initializing...");
        File src = null;
        if (args.length > 0 && !(src = new File(args[0])).canRead()) {
            src = null;
        }
        PDFMaker self = new PDFMaker(translator, src);
        SwingUtilities.updateComponentTreeUI(self);
    }

    public PDFMaker(Translator translator, File src) throws Exception {
        super(null, TITLE, translator, SQSFileChooser.createOpenSQSSourceChooser(src), "SQS Source File: ", SQSFileChooser.createSavePDFFileChooser(src), "PDF File: ");
        this.setSize(300, 160);
        this.setVisible(true);
    }
}

