<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2" xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs" version="1.0">
	<xsl:template name="sqs:matrix-forms">
		<xhtml2:table border="1" xhtml2:class="matrix-forms" id="{@xforms:ref}" sqs:form-width-ratio="{@sqs:form-width-ratio}">
		<xsl:variable name="qid" select="@xforms:ref"/>
			<xhtml2:thead>
				<xhtml2:tr>
					<xhtml2:th xhtml2:colspan="2" xhtml2:rowspan="2"/>
					<xsl:for-each select="sqs:column-array/sqs:*">
						<xsl:choose>
							<xsl:when test="local-name()='select1' or local-name()='select'">
								<xhtml2:th xhtml2:colspan="{count(xforms:item)}" xhtml2:class="label" sqs:column-group-index="{position()}" sqs:xforms-type="{local-name()}">
									<xsl:call-template name="xforms:hint"/>

								</xhtml2:th>
							</xsl:when>
							<xsl:otherwise>
								<xhtml2:th xhtml2:colspan="1" xhtml2:rowspan="2" xhtml2:class="label" sqs:xforms-type="{local-name()}" sqs:width="{@sqs:width}">
									<xsl:call-template name="xforms:hint"/>
								</xhtml2:th>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xhtml2:tr>
				<xhtml2:tr>
					<xsl:for-each select="sqs:column-array/*">
						<xsl:variable name="column-group-index" select="position()"/>
						<xsl:for-each select="xforms:item">
							<xhtml2:th sqs:column-group-index="{$column-group-index}" sqs:value="{xforms:value}">
								<xsl:call-template name="xforms:label"/>
							</xhtml2:th>
						</xsl:for-each>
					</xsl:for-each>
				</xhtml2:tr>
			</xhtml2:thead>
			<xhtml2:tbody>
				<xsl:for-each select="sqs:row-array/xforms:group">
<xsl:variable name="row-id"><xsl:number level="any" from="sqs:row-array" count="xforms:group"/></xsl:variable>
					<xsl:element name="xhtml2:tr">
						<xsl:attribute name="id"><xsl:value-of select="$internal-destination-prefix-question"/><xsl:value-of select="$qid"/>/r[<xsl:value-of select="$row-id"/>]</xsl:attribute>
						<xhtml2:th>
							<xsl:call-template name="xforms:label"/>
						</xhtml2:th>
						<xhtml2:td xhtml2:class="matrix-forms-label">
							<xsl:call-template name="xforms:hint"/>
							<xsl:call-template name="xforms:help"/>
							<xsl:call-template name="xforms:alart"/>
						</xhtml2:td>
						<xsl:for-each select="ancestor::sqs:matrix-forms/sqs:column-array/sqs:*">
							<xsl:call-template name="matrix-forms-row-column">
								<xsl:with-param name="qid" select="$qid"/>
								<xsl:with-param name="row-id" select="$row-id"/>
								<xsl:with-param name="col-id"><xsl:number level="any" count="sqs:select|sqs:select1|sqs:input|sqs:textarea" from="sqs:column-array"/></xsl:with-param>
								<!-- sqs:range -->
							</xsl:call-template>
						</xsl:for-each>
					</xsl:element>
				</xsl:for-each>
			</xhtml2:tbody>
		</xhtml2:table>
	</xsl:template>

<xsl:template name="matrix-forms-row-column">
	<xsl:param name="qid"/>
	<xsl:param name="row-id"/>
	<xsl:param name="col-id"/>
	<xsl:choose>
		<xsl:when test="local-name()='select' or local-name()='select1'">
			<xsl:call-template name="matrix-forms-row-column-set">
				<xsl:with-param name="qid" select="$qid"/>
				<xsl:with-param name="row-id" select="$row-id"/>
				<xsl:with-param name="col-id" select="$col-id"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="local-name()='input' or local-name()='textarea'">
			<xsl:call-template name="matrix-forms-row-textarea">
				<xsl:with-param name="qid" select="$qid"/>
				<xsl:with-param name="row-id" select="$row-id"/>
				<xsl:with-param name="col-id" select="$col-id"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xhtml2:td xhtml2:colspan="1">
				<xsl:copy-of select="."/>
			</xhtml2:td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="matrix-forms-row-column-set">
	<xsl:param name="qid"/>
	<xsl:param name="row-id"/>
	<xsl:param name="col-id"/>
	<xsl:variable name="colspan"><xsl:value-of select="count(xforms:item)"/></xsl:variable>

	<xhtml2:td xhtml2:class="matrix-forms-column-set" xhtml2:colspan="{$colspan}">
		<xsl:element name="xforms:{local-name()}">
			<xsl:attribute name="xforms:ref"><xsl:value-of select="$qid"/>/r[<xsl:value-of select="$row-id"/>]/c[<xsl:value-of select="$col-id"/>]</xsl:attribute>
			<xsl:attribute name="sqs:pxform-type">matrix-forms</xsl:attribute>
			<xsl:for-each select="*">
<xsl:choose>
	<xsl:when test="local-name='cols'">
		<xsl:attribute name="xhtml2:cols"><xsl:value-of select="$colspan"/></xsl:attribute>
	</xsl:when>
	<xsl:otherwise>
		<xsl:copy-of select="."/>
	</xsl:otherwise>
</xsl:choose>
			</xsl:for-each>
		</xsl:element>
	</xhtml2:td>
</xsl:template>
<xsl:template name="matrix-forms-row-textarea">
	<xsl:param name="qid"/>
	<xsl:param name="row-id"/>
	<xsl:param name="col-id"/>	
	<xhtml2:td xhtml2:colspan="1" xhtml2:class="matrix-forms-td">
<xsl:element name="xforms:{local-name()}">
<xsl:apply-templates select="@sqs:*"/>
<xsl:attribute name="xforms:ref"><xsl:value-of select="$qid"/>/r[<xsl:value-of select="$row-id"/>]/c[<xsl:value-of select="$col-id"/>]</xsl:attribute>
<xsl:copy-of select="xforms:hint"/>
</xsl:element>
	</xhtml2:td>
</xsl:template>


</xsl:stylesheet>
