/*

 SourceEditorFrame.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/07/31

 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JMenuBar;
import javax.swing.border.EmptyBorder;

import net.sf.sqs_xml.swing.SwingUtil;


/**
 * @author hiroya
 *
 */
public class SourceEditorFrame extends JFrame {
    public static final long serialVersionUID = 0;
	private JPanel jContentPane = null;
	private JMenuBar menuBar = null;
	
	public SourceEditorFrame(SourceEditorMenuBarMediator menuBar,
	        				 SourceEditorToolBar toolBar,
	        				 Component mainPanel) {
		super();
		addWindowListener(SwingUtil.createConfirmOnExitAdapter(this, "Exit Confirmation", "終了してよろしいですか?"));
		
		JPanel body = new JPanel();
		body.setLayout(new BorderLayout());
		body.setBorder(new EmptyBorder(0, 7, 7, 5));
		body.add(toolBar, BorderLayout.NORTH);
		body.add(mainPanel, BorderLayout.CENTER);

		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(menuBar.getMenuBar(), java.awt.BorderLayout.NORTH);
		getContentPane().add(body, BorderLayout.CENTER);
	}
}
